﻿using AutoMapper;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class RoleService : IAutoInjection
    {
        private PerforRoleRepository _roleRepository;
        private PerforUserroleRepository _userroleRepository;

        public RoleService(PerforRoleRepository roleRepository,
            PerforUserroleRepository userroleRepository)
        {
            this._roleRepository = roleRepository;
            this._userroleRepository = userroleRepository;
        }

        /// <summary>
        /// 获取用户角色
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public List<RoleResponse> GetUserRole(int userid)
        {
            if (userid <= 0)
                throw new PerformanceException($"userid：{userid} 错误");

            var joinList = _userroleRepository.GetEntities(t => t.UserID == userid).ToList();
            if (joinList == null && joinList.Count == 0)
                return null;

            var roles = _roleRepository.GetEntities(t => joinList.Select(j => j.RoleID).Contains(t.ID)).ToList();

            return Mapper.Map<List<RoleResponse>>(roles);
        }
    }
}
