﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Performance.DtoModels
{
    public enum ExcelVersion
    {
        xlsx,
        xls
    }


    /// <summary> 核算单元类型 </summary>
    public enum UnitType
    {
        [Description("医生组")]
        医生组 = 1,
        [Description("护理组")]
        护理组 = 2,
        [Description("医技组")]
        医技组 = 3,
        [Description("专家组")]
        专家组 = 4,
        //[Description("其他")]
        //其他 = 5,
        [Description("特殊核算组")]
        特殊核算组 = 6,
        [Description("其他医生组")]
        其他医生组 = 7,
        [Description("其他护理组")]
        其他护理组 = 8,
        [Description("其他医技组")]
        其他医技组 = 9,
        [Description("行政高层")]
        行政高层 = 10,
        [Description("行政中层")]
        行政中层 = 11,
        [Description("行政后勤")]
        行政后勤 = 12,
    }

    public enum SheetType
    {
        /// <summary> 无法识别 </summary>
        [Description("无法识别")]
        Unidentifiable = 1,
        /// <summary> 行政中高层 </summary>
        [Description("行政中高层")]
        Employee = 2,
        /// <summary> 收入 </summary>
        [Description("收入")]
        Income = 3,
        /// <summary> 其他收入 </summary>
        [Description("其他收入")]
        OtherIncome = 4,
        /// <summary> 支出 </summary>
        [Description("支出")]
        Expend = 5,
        /// <summary> 加班 </summary>
        [Description("加班")]
        Overtime = 6,
        /// <summary> 工作量 </summary>
        [Description("工作量")]
        Workload = 7,
        /// <summary> 特殊核算单元 </summary>
        [Description("特殊核算单元")]
        SpecialUnit = 8,
        /// <summary> 临床科室医护绩效测算基础 </summary>
        [Description("临床科室医护绩效测算基础")]
        AccountBasic = 9,

        /// <summary> 科室经济核算汇总表 </summary>
        [Description("科室经济核算汇总表")]
        ComputeEconomic = 10,
        /// <summary> 医生工作量计算 </summary>
        [Description("医生工作量计算")]
        ComputeDoctorWorkload = 11,
        /// <summary> 护士工作量计算 </summary>
        [Description("护士工作量计算")]
        ComputeNurseWorkload = 12,
        /// <summary> 临床科室医生绩效测算表 </summary>
        [Description("临床科室医生绩效测算表")]
        ComputeDoctorAccount = 13,
        /// <summary> 临床科室护士绩效测算表 </summary>
        [Description("临床科室护士绩效测算表")]
        ComputeNurseAccount = 14,

        /// <summary> 业务中层 </summary>
        [Description("业务中层")]
        ClinicEmployee = 15,

        /// <summary> 特殊临床科室医护绩效测算基础 </summary>
        [Description("特殊临床科室医护绩效测算基础")]
        AccountBasicSpecial = 16,

        /// <summary> 科室绩效医院奖罚 </summary>
        [Description("科室绩效医院奖罚")]
        AccountExtra = 17,

        /// <summary> 业务中层行政中高层医院奖罚 </summary>
        [Description("业务中层行政中高层医院奖罚")]
        PersonExtra = 18,

        /// <summary> 科室药占比考核 </summary>
        [Description("科室药占比考核")]
        AccountDrugAssess = 19,

        /// <summary> 科室材料考核 </summary>
        [Description("科室材料考核")]
        AccountMaterialsAssess = 20,

        /// <summary> 行政后勤 </summary>
        [Description("行政后勤")]
        LogisticsEmployee = 21,


        /// <summary> 科室材料考核 </summary>
        [Description("科室考核")]
        AccountScoreAverage = 25,

        /// <summary> 科室调节后其他绩效 </summary>
        [Description("科室调节后其他绩效")]
        AccountAdjustLaterOtherFee = 26,

        /// <summary> 业务中层行政中高层调节后其他绩效 </summary>
        [Description("业务中层行政中高层调节后其他绩效")]
        PersonAdjustLaterOtherFee = 27,

        /// <summary> 其他工作量（不参与核算） </summary>
        [Description("其他工作量")]
        OtherWorkload = 28,
    }

    /// <summary>
    /// 核算单元类型
    /// </summary>
    public enum AccountUnitType
    {
        /// <summary>  </summary>
        [Description("")]
        Null = 1,
        /// <summary> 临床科室 </summary>
        [Description("科主任")]
        科主任 = 2,
        /// <summary> 临床科室 </summary>
        [Description("护士长")]
        护士长 = 3,
        /// <summary> 行政高层 </summary>
        [Description("行政高层")]
        行政高层 = 4,
        /// <summary> 临床科室 </summary>
        [Description("行政中层")]
        行政中层 = 5,
        /// <summary> 临床科室 </summary>
        [Description("行政工勤")]
        行政工勤 = 6,
    }

    public enum PerforType
    {
        [Description("临床科室主任人均绩效")]
        临床主任,
        [Description("临床科室副主任人均绩效")]
        临床副主任,
        [Description("医技科室主任人均绩效")]
        医技主任,
        [Description("医技科室副主任人均绩效")]
        医技副主任,
        [Description("护士长人均绩效")]
        护士长,
        [Description("护士人均绩效")]
        护士,
        [Description("临床主任护士长平均")]
        临床主任护士长平均,
        [Description("临床主任医技主任护士长平均")]
        临床主任医技主任护士长平均,
        [Description("临床医生人均绩效")]
        临床医生,
        [Description("医技医生人均绩效")]
        医技医生,
        [Description("行政高层人均绩效")]
        行政高层,
        [Description("行政中层人均绩效")]
        行政中层,
        [Description("行政工勤人均绩效")]
        行政工勤,
        [Description("医生护士平均绩效")]
        医生护士平均,
    }

    /// <summary>
    /// 保底绩效
    /// </summary>
    public enum MinimumType
    {
        [Description("保底绩效临床医生人均绩效")]
        保底临床医生 = 1,
        [Description("保底绩效医技医生人均绩效")]
        保底医技医生 = 2,
        [Description("保底绩效护士人均绩效")]
        保底护士 = 3,
        [Description("保底绩效行政工勤人均绩效")]
        保底工勤 = 4,
        [Description("自定义保底绩效")]
        自定义保底 = 5,
    }

    ///// <summary>
    ///// 当前枚举为效率绩效、规模绩效中系数中文名称
    ///// 对应表cof_director中JobTitle 全文字匹配
    ///// </summary>
    //public enum DirectorType
    //{
    //    临床科室主任,
    //    临床科室副主任,
    //    医技科室主任,
    //    医技科室副主任,
    //    临床科室护士长,
    //}
}
