﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class PerData : IPerData
    {
        /// <summary>
        /// 核算单元类别 （医生组/护理组）
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元名称
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }
        /// <summary>
        /// 列头类型名称
        /// </summary>
        public string TypeName { get; set; }
        /// <summary>
        /// 人员姓名
        /// </summary>
        public string EmployeeName { get; set; }
        /// <summary>
        /// 人员工号
        /// </summary>
        public string JobNumber { get; set; }
        /// <summary>
        /// 单元格注释
        /// </summary>
        public string Annotation { get; set; }
        /// <summary>
        /// 单元格备注
        /// </summary>
        public string Remark { get; set; }
        /// <summary>
        /// 单元格value
        /// </summary>
        public decimal? CellValue { get; set; }
        /// <summary>
        /// 1 加 2 减 3 乘
        /// </summary>
        public Nullable<int> ComputRule { get; set; }
        /// <summary>
        /// 系数值
        /// </summary>
        public decimal? FactorValue { get; set; }
        /// <summary>
        /// 是否带入系数计算
        /// </summary>
        public bool IsFactor { get; set; }
        /// <summary>
        /// 1 汇总  2原始数据
        /// </summary>
        public Nullable<int> IsTotal { get; set; }
        /// <summary>
        /// 行号
        /// </summary>
        public int RowNumber { get; set; }
        /// <summary>
        /// 行坐标
        /// </summary>
        public int PointRow { get; set; }
        /// <summary>
        /// 列坐标
        /// </summary>
        public int PointCell { get; set; }
        public string SignID { get; set; }

        public decimal? MedicineFactor { get; set; }
    }
}
