﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    /// <summary>
    /// excel读取数据位置信息
    /// </summary>
    public class PerSheetPoint
    {
        /// <summary>
        /// 列头开始行（0开始）
        /// </summary>
        public int? HeaderFirstRowNum { get; set; }
        /// <summary>
        /// 列头结束行（0开始）
        /// </summary>
        public int? HeaderLastRowNum { get; set; }
        /// <summary>
        /// 列头开始列（0开始）
        /// </summary>
        public int? HeaderFirstCellNum { get; set; }
        /// <summary>
        /// 数据开始行
        /// </summary>
        public int? DataFirstRowNum { get; set; }

        public List<AccountingUnit> AccountingUnit { get; set; }
        /// <summary>
        /// 汇总列
        /// </summary>
        public int? TotalCellNum { get; set; }
    }

    public class AccountingUnit
    {
        /// <summary>
        /// 系数行号
        /// </summary>
        public int? FactorRow { get; set; }
        /// <summary>
        /// 核算单元列
        /// </summary>
        public int? AccountingUnitCellNum { get; set; }
        /// <summary>
        /// 科室名称
        /// </summary>
        public int? DeptCellNum { get; set; }
        /// <summary>
        /// 核算单元类型列
        /// </summary>
        public int? UnitTypeNum { get; set; }
        /// <summary>
        /// 核算单元类型
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 人员名称
        /// </summary>
        public int? EmpNameCellNum { get; set; }
        /// <summary>
        /// 人员工号
        /// </summary>
        public int? JobCellNum { get; set; }
    }
}
