//-----------------------------------------------------------------------
// <copyright file=" im_employee.cs">
// * FileName: .cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 
    /// </summary>
    [Table("im_employee")]
	public class im_employee
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int ID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> AllotID { get; set; }
    
        /// <summary>
        /// sheet页id
        /// </summary>
        public Nullable<int> SheetID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> RowNumber { get; set; }
    
        /// <summary>
        /// 科室类别(例如 医技科室 临床科室 其他科室)
        /// </summary>
        public string AccountType { get; set; }
    
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
    
        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }
    
        /// <summary>
        /// 绩效基数核算参考对象
        /// </summary>
        public string FitPeople { get; set; }

        /// <summary>
        /// 绩效基础核算参考值
        /// </summary>
        public Nullable<decimal> FitPeopleValue { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象取值比例（如临床科室护士*95%）
        /// </summary>
        public Nullable<decimal> FitPeopleRatio { get; set; }
    
        /// <summary>
        /// 人员工号
        /// </summary>
        public string PersonnelNumber { get; set; }
    
        /// <summary>
        /// 医生姓名
        /// </summary>
        public string DoctorName { get; set; }
    
        /// <summary>
        /// 职称
        /// </summary>
        public string JobTitle { get; set; }
    
        /// <summary>
        /// 岗位系数
        /// </summary>
        public Nullable<decimal> PostCoefficient { get; set; }
    
        /// <summary>
        /// 参加工作时间
        /// </summary>
        public Nullable<DateTime> WorkTime { get; set; }
    
        /// <summary>
        /// 考核得分率
        /// </summary>
        public Nullable<decimal> ScoreAverageRate { get; set; }
    
        /// <summary>
        /// 出勤率
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }
    
        /// <summary>
        /// 核算单元医生数
        /// </summary>
        public Nullable<int> PeopleNumber { get; set; }
    
        /// <summary>
        /// 工作量绩效
        /// </summary>
        public Nullable<decimal> Workload { get; set; }
    
        /// <summary>
        /// 其他绩效
        /// </summary>
        public Nullable<decimal> OtherPerfor { get; set; }

        /// <summary>
        /// 夜班费
        /// </summary>
        public Nullable<decimal> NightWorkPerfor { get; set; }
    
        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> Punishment { get; set; }
    
        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }
    
        /// <summary>
        /// 发放系数
        /// </summary>
        public Nullable<decimal> Grant { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<DateTime> UpdateDate { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> UpdateUser { get; set; }
        /// <summary>
        /// 考核前其他绩效
        /// </summary>
        public Nullable<decimal> AssessBeforeOtherFee { get; set; }
        /// <summary>
        /// 考核后其他绩效
        /// </summary>
        public Nullable<decimal> AssessLaterOtherFee { get; set; }
        /// <summary>
        /// 调节后其他绩效
        /// </summary>
        public Nullable<decimal> AdjustLaterOtherFee { get; set; }
    }
}
