//-----------------------------------------------------------------------
// <copyright file=" per_employee.cs">
// * FileName: 绩效人员表.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 绩效人员表
    /// </summary>
    [Table("per_employee")]
	public class per_employee
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int Id { get; set; }
    
        /// <summary>
        /// 医院Id
        /// </summary>
        public Nullable<int> HospitalId { get; set; }
    
        /// <summary>
        /// 绩效Id
        /// </summary>
        public Nullable<int> AllotId { get; set; }
    
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
    
        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }
    
        /// <summary>
        /// 姓名
        /// </summary>
        public string DoctorName { get; set; }
    
        /// <summary>
        /// 员工工号
        /// </summary>
        public string PersonnelNumber { get; set; }
    
        /// <summary>
        /// 正式/临聘
        /// </summary>
        public string JobCategory { get; set; }
    
        /// <summary>
        /// 职务
        /// </summary>
        public string Duty { get; set; }
    
        /// <summary>
        /// 职称
        /// </summary>
        public string JobTitle { get; set; }
    
        /// <summary>
        /// 人员类别
        /// </summary>
        public string UnitType { get; set; }
    
        /// <summary>
        /// 出勤率
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }
    
        /// <summary>
        /// 出勤天数
        /// </summary>
        public Nullable<int> AttendanceDay { get; set; }
    
        /// <summary>
        /// 核算人数
        /// </summary>
        public Nullable<decimal> PermanentStaff { get; set; }
    
        /// <summary>
        /// 效率人数
        /// </summary>
        public Nullable<decimal> EfficiencyNumber { get; set; }
    
        /// <summary>
        /// 参加工作时间
        /// </summary>
        public Nullable<DateTime> WorkTime { get; set; }
    
        /// <summary>
        /// 出生年月
        /// </summary>
        public Nullable<DateTime> BirthDate { get; set; }
    
        /// <summary>
        /// 年龄
        /// </summary>
        public Nullable<int> Age { get; set; }
    
        /// <summary>
        /// 预留比例
        /// </summary>
        public Nullable<decimal> ReservedRatio { get; set; }
    
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<DateTime> CreateTime { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> CreateUser { get; set; }
    }
}
