﻿using AutoMapper;
using Newtonsoft.Json.Linq;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class PerSheetService : IAutoInjection
    {
        private PerHeaderService _perHeader;
        private PerforCofdrugpropRepository _perforCofdrugpropRepository;
        private PerforCofdrugtypeRepository _perforCofdrugtypeRepository;
        public PerSheetService(PerHeaderService perHeader,
            PerforCofdrugpropRepository perforCofdrugpropRepository,
             PerforCofdrugtypeRepository perforCofdrugtypeRepository)
        {
            _perHeader = perHeader;
            _perforCofdrugpropRepository = perforCofdrugpropRepository;
            _perforCofdrugtypeRepository = perforCofdrugtypeRepository;
        }
        /// <summary>
        /// 解析excel数据
        /// </summary>
        /// <param name="sheet"></param>
        /// <returns></returns>
        public PerSheet SheetAccountBasicSpecial(ISheet sheet, bool isnew)
        {
            PerSheet perSheet = new PerSheet
            {
                SheetName = sheet.SheetName,
                SheetType = SheetType.AccountBasicSpecial,
                ModuleName = EnumHelper.GetDescription(SheetType.AccountBasicSpecial),
            };

            var sheetRead = PerSheetDataFactory.GetDataRead(perSheet.SheetType, isnew);
            var perHeader = _perHeader.GetPerHeader(sheet, sheetRead.Point);
            var headerReverse = _perHeader.GetPerHeaderReverse(perHeader);

            perSheet.PerHeader = perHeader;
            perSheet.PerData = sheetRead.ReadData(sheet, headerReverse);
            return perSheet;
        }

        /// <summary>
        /// 解析excel数据
        /// </summary>
        /// <param name="sheet"></param>
        /// <returns></returns>
        public PerSheet Sheet(ISheet sheet, bool isnew)
        {
            PerSheet perSheet = new PerSheet();
            perSheet.SheetName = sheet.SheetName;
            perSheet.SheetType = GetSheetType(sheet.SheetName);
            perSheet.ModuleName = EnumHelper.GetDescription(perSheet.SheetType);

            if (perSheet.SheetType == SheetType.Unidentifiable)
                return null;

            var sheetRead = PerSheetDataFactory.GetDataRead(perSheet.SheetType, isnew);
            var perHeader = _perHeader.GetPerHeader(sheet, sheetRead.Point);
            var headerReverse = _perHeader.GetPerHeaderReverse(perHeader);

            perSheet.PerHeader = perHeader;
            perSheet.PerData = sheetRead.ReadData(sheet, headerReverse);
            return perSheet;
        }

        /// <summary>
        /// 判断sheet适用模板类型
        /// </summary>
        /// <param name="sheetName"></param>
        /// <returns></returns>
        public SheetType GetSheetType(string sheetName)
        {
            if (sheetName.StartsWith("行政中高层"))
                return SheetType.Employee;
            else if (sheetName.StartsWith("业务中层"))
                return SheetType.ClinicEmployee;
            else if (sheetName.StartsWith("行政后勤"))
                return SheetType.LogisticsEmployee;
            else if (sheetName.StartsWith("1.0"))
                return SheetType.OtherIncome;
            else if (sheetName.StartsWith("1."))
                return SheetType.Income;
            else if (sheetName.StartsWith("2."))
                return SheetType.Expend;
            else if (sheetName.StartsWith("3.1") || sheetName.StartsWith("3.2"))
                return SheetType.Workload;
            else if (sheetName.StartsWith("3."))
                return SheetType.OtherWorkload;
            else if (sheetName.StartsWith("4.1"))
                return SheetType.AccountBasic;
            else if (sheetName.StartsWith("4.2"))
                return SheetType.SpecialUnit;
            else if (sheetName.StartsWith("5.1"))
                return SheetType.AccountExtra;
            else if (sheetName.StartsWith("5.2"))
                return SheetType.PersonExtra;
            else if (sheetName.StartsWith("5.3"))
                return SheetType.AccountDrugAssess;
            else if (sheetName.StartsWith("5.4"))
                return SheetType.AccountMaterialsAssess;
            else if (sheetName.StartsWith("6.1"))
                return SheetType.AccountScoreAverage;
            else if (sheetName.StartsWith("6.2"))
                return SheetType.AccountAdjustLaterOtherFee;
            else if (sheetName.StartsWith("6.3"))
                return SheetType.PersonAdjustLaterOtherFee;
            return SheetType.Unidentifiable;
        }
    }
}
