//-----------------------------------------------------------------------
// <copyright file=" ag_employee.cs">
// * FileName: 二次分配人员名单.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 二次分配人员名单
    /// </summary>
    [Table("ag_employee")]
    public class ag_employee
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int ID { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> AllotID { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> AgainAllotID { get; set; }

        /// <summary>
        /// 行号
        /// </summary>
        public Nullable<int> RowNumber { get; set; }

        /// <summary>
        /// 姓名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 职务
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 职称系数
        /// </summary>
        public Nullable<decimal> JobFactor { get; set; }

        /// <summary>
        /// 出勤
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }

        /// <summary>
        /// 年资
        /// </summary>
        public Nullable<decimal> YearFactor { get; set; }

        /// <summary>
        /// 重点奖励
        /// </summary>
        public Nullable<decimal> Award { get; set; }

        /// <summary>
        /// 管理津贴
        /// </summary>
        public Nullable<decimal> Allowance { get; set; }

        /// <summary>
        /// 单独核算人员绩效
        /// </summary>
        public Nullable<decimal> AlonePerfor { get; set; }

        /// <summary>
        /// 夜班费
        /// </summary>
        public Nullable<decimal> NightShift { get; set; }

        /// <summary>
        /// 职称出勤系数(需计算)
        /// </summary>
        public Nullable<decimal> JobAttendanceFactor { get; set; }

        /// <summary>
        /// 年资出勤系数(需计算)
        /// </summary>
        public Nullable<decimal> YearAttendanceFactor { get; set; }

        /// <summary>
        /// 职称出勤绩效(需计算)
        /// </summary>
        public Nullable<decimal> JobAttendancePerfor { get; set; }

        /// <summary>
        /// 应发绩效(需计算)
        /// </summary>
        public Nullable<decimal> GiveFee { get; set; }

        /// <summary>
        /// 实发绩效(需计算)
        /// </summary>
        public Nullable<decimal> RealGiveFee { get; set; }
    }
}
