﻿using RestSharp;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Performance.Infrastructure
{
    public class RestSharpHelper
    {
        public const string tokenHeader = "Authorization";

        public RestClient SetUrl(string baseUrl, string endpoint)
        {
            var url = Path.Combine(baseUrl, endpoint);
            var restClient = new RestClient(url);
            return restClient;
        }

        public RestRequest CreateGetRequest(string tokenHeader = tokenHeader, string token = null, int timeout = -1)
        {
            var restRequest = new RestRequest(Method.GET);
            restRequest.AddHeader(tokenHeader, token);
            restRequest.AddHeader("Accept", "application/json");
            restRequest.Timeout = timeout;
            return restRequest;
        }

        public RestRequest CreatePostRequest(string payload, string tokenHeader = tokenHeader, string token = null, int timeout = -1)
        {
            var restRequest = new RestRequest(Method.POST);
            restRequest.AddHeader(tokenHeader, token);
            restRequest.AddHeader("Accept", "application/json");
            restRequest.AddParameter("application/json", payload, ParameterType.RequestBody);
            restRequest.Timeout = timeout;
            return restRequest;
        }

        public RestRequest CreateFileRequest(string[] files, Dictionary<string, object> parameter = null, string tokenHeader = tokenHeader, string token = null, int timeout = -1)
        {
            var restRequest = new RestRequest(Method.POST);
            restRequest.AddHeader(tokenHeader, token);
            if (files != null && files.Any(t => !string.IsNullOrEmpty(t)))
            {
                int i = 1;
                foreach (var file in files.Where(t => !string.IsNullOrEmpty(t)))
                {
                    restRequest.AddFile(i.ToString(), file);
                    i++;
                }
            }
            if (parameter != null)
            {
                foreach (var item in parameter)
                {
                    restRequest.AddParameter(item.Key, item.Value);
                }
            }
            restRequest.Timeout = timeout;
            return restRequest;
        }

        public RestRequest CreatePutRequest(string payload, string tokenHeader = tokenHeader, string token = null, int timeout = -1)
        {
            var restRequest = new RestRequest(Method.PUT);
            restRequest.AddHeader(tokenHeader, token);
            restRequest.AddHeader("Accept", "application/json");
            restRequest.AddParameter("application/json", payload, ParameterType.RequestBody);
            restRequest.Timeout = timeout;
            return restRequest;
        }

        public RestRequest CreateDeleteRequest(string tokenHeader = tokenHeader, string token = null, int timeout = -1)
        {
            var restRequest = new RestRequest(Method.DELETE);
            restRequest.AddHeader(tokenHeader, token);
            restRequest.AddHeader("Accept", "application/json");
            restRequest.Timeout = timeout;
            return restRequest;
        }

        public IRestResponse GetResponse(RestClient client, RestRequest request)
        {
            return client.Execute(request);
        }

        public async Task<IRestResponse> GetResponseAsync(RestClient client, RestRequest request)
        {
            return await client.ExecuteAsync(request);
        }

        public DTO GetContent<DTO>(IRestResponse response)
        {
            var content = response.Content;
            DTO dtoObject = JsonHelper.Deserialize<DTO>(content);
            return dtoObject;
        }
    }
}
