﻿using Microsoft.Extensions.Logging;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.EntityModels.Entity;
using Performance.Repository;
using Performance.Repository.Repository;
using System;
using System.Linq;
using static Performance.DtoModels.Attendance;

namespace Performance.Services
{
    public class CopyService : IAutoInjection
    {
        private readonly ILogger<ConfigService> _logger;
        private readonly PerforPerdeptdicRepository _perdeptdicRepository;
        private readonly PerforCofworkitemRepository _workitemRepository;
        private readonly PerforCofagainRepository _againRepository;
        private readonly PerforCofdrugtypeRepository _drugtypeRepository;
        private readonly PerforCofdepttypeRepository _perforCofdepttypeRepository;
        private readonly PerforCofaccountingRepository _cofaccountingRepository;
        private readonly PerforCofdrugtypeDisburseRepository _drugtypeDisburseRepository;
        private readonly PerforCofdrugtypefactorRepository _cofdrugtypefactorRepository;
        private readonly PerfoPperAttendanceTypeRepository _pperAttendanceTypeRepository;
        private readonly PerforPerAssessCategoryRepository _perforPerAssessCategoryRepository;
        private readonly PerforPerAssessSchemeRepository _perforPerAssessSchemeRepository;
        private readonly PerforPerAssessSchemeItemsRepository _perforPerAssessSchemeItemsRepository;
        private readonly PerforPerAssessSchemeTargetRepository _perforPerAssessSchemeTargetRepository;
        private readonly PerforPerAssessIssueSchemeRepository _perforPerAssessIssueSchemeRepository;
        private readonly PerforPerAttendanceDeptRepository _perforPerAttendanceDeptRepository;

        public CopyService(
            ILogger<ConfigService> logger,
            PerforPerdeptdicRepository perdeptdicRepository,
            PerforCofagainRepository againRepository,
            PerforCofdrugtypeRepository drugtypeRepository,
            PerforCofworkitemRepository workitemRepository,
            PerforCofdepttypeRepository perforCofdepttypeRepository,
            PerforCofaccountingRepository cofaccountingRepository,
            PerforCofdrugtypeDisburseRepository drugtypeDisburseRepository,
            PerforCofdrugtypefactorRepository cofdrugtypefactorRepository,
            PerfoPperAttendanceTypeRepository pperAttendanceTypeRepository,
            PerforPerAssessCategoryRepository perforPerAssessCategoryRepository,
            PerforPerAssessSchemeRepository perforPerAssessSchemeRepository,
            PerforPerAssessSchemeItemsRepository perforPerAssessSchemeItemsRepository,
            PerforPerAssessSchemeTargetRepository perforPerAssessSchemeTargetRepository,
            PerforPerAssessIssueSchemeRepository perforPerAssessIssueSchemeRepository,
            PerforPerAttendanceDeptRepository perforPerAttendanceDeptRepository
            )
        {
            _logger = logger;
            _perdeptdicRepository = perdeptdicRepository;
            _workitemRepository = workitemRepository;
            _againRepository = againRepository;
            _drugtypeRepository = drugtypeRepository;
            _perforCofdepttypeRepository = perforCofdepttypeRepository;
            _cofaccountingRepository = cofaccountingRepository;
            _drugtypeDisburseRepository = drugtypeDisburseRepository;
            _cofdrugtypefactorRepository = cofdrugtypefactorRepository;
            _pperAttendanceTypeRepository = pperAttendanceTypeRepository;
            _perforPerAssessCategoryRepository = perforPerAssessCategoryRepository;
            _perforPerAssessSchemeRepository = perforPerAssessSchemeRepository;
            _perforPerAssessSchemeItemsRepository = perforPerAssessSchemeItemsRepository;
            _perforPerAssessSchemeTargetRepository = perforPerAssessSchemeTargetRepository;
            _perforPerAssessIssueSchemeRepository = perforPerAssessIssueSchemeRepository;
            _perforPerAttendanceDeptRepository = perforPerAttendanceDeptRepository;
        }


        public void Copy_WorkItems(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy workItems");
            var workItems = _workitemRepository.GetEntities(t => t.AllotID == allot.ID);
            if (delHistotyData && workItems != null && workItems.Any())
                flag = _workitemRepository.RemoveRange(workItems.ToArray());
            if (flag || workItems == null || !workItems.Any())
            {
                workItems = _workitemRepository.GetEntities(t => t.AllotID == prevAllotId) ?? _workitemRepository.GetEntities(t => t.AllotID == -1);
                if (workItems != null && workItems.Any())
                {
                    var newWorkItems = workItems.Select(t => new cof_workitem { AllotID = allot.ID, Type = t.Type, Item = t.Item });
                    _workitemRepository.AddRange(newWorkItems.ToArray());
                }
            }
        }


        public void Copy_DrugTypes(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy drugTypes");
            var drugTypes = _drugtypeRepository.GetEntities(t => t.AllotID == allot.ID && t.HospitalId == allot.HospitalId);
            if (delHistotyData && drugTypes != null && drugTypes.Any())
                flag = _drugtypeRepository.RemoveRange(drugTypes.ToArray());
            if (flag || drugTypes == null || !drugTypes.Any())
            {
                drugTypes = _drugtypeRepository.GetEntities(t => t.AllotID == prevAllotId && t.HospitalId == allot.HospitalId) ?? _drugtypeRepository.GetEntities(t => t.AllotID == -1);
                if (drugTypes != null && drugTypes.Any())
                {
                    var newDrugTypes = drugTypes.Select(t => new cof_drugtype { HospitalId = allot.HospitalId, AllotID = allot.ID, Charge = t.Charge, ChargeType = t.ChargeType });
                    _drugtypeRepository.AddRange(newDrugTypes.ToArray());
                }
            }
        }


        public void Copy_DrugTypeDisburses(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy drugTypeDisburses");
            var drugTypeDisburses = _drugtypeDisburseRepository.GetEntities(t => t.AllotID == allot.ID && t.HospitalId == allot.HospitalId);
            if (delHistotyData && drugTypeDisburses != null && drugTypeDisburses.Any())
                flag = _drugtypeDisburseRepository.RemoveRange(drugTypeDisburses.ToArray());
            if (flag || drugTypeDisburses == null || !drugTypeDisburses.Any())
            {
                drugTypeDisburses = _drugtypeDisburseRepository.GetEntities(t => t.AllotID == prevAllotId && t.HospitalId == allot.HospitalId)
                    ?? _drugtypeDisburseRepository.GetEntities(t => t.AllotID == -1);
                if (drugTypeDisburses != null && drugTypeDisburses.Any())
                {
                    var newDrugTypeDisburses = drugTypeDisburses.Select(t => new cof_drugtype_disburse { HospitalId = allot.HospitalId, AllotID = allot.ID, Charge = t.Charge, ChargeType = t.ChargeType });
                    _drugtypeDisburseRepository.AddRange(newDrugTypeDisburses.ToArray());
                }
            }
        }


        public void Copy_DrugTypeFactors(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            Copy_DrugTypes(allot, prevAllotId, delHistotyData);

            var flag = delHistotyData;
            _logger.LogInformation($"copy drugTypeFactors");
            var drugTypeFactors = _cofdrugtypefactorRepository.GetEntities(t => t.AllotID == allot.ID && t.HospitalId == allot.HospitalId);
            if (delHistotyData && drugTypeFactors != null && drugTypeFactors.Any())
                flag = _cofdrugtypefactorRepository.RemoveRange(drugTypeFactors.ToArray());
            if (flag || drugTypeFactors == null || !drugTypeFactors.Any())
            {
                drugTypeFactors = _cofdrugtypefactorRepository.GetEntities(t => t.AllotID == prevAllotId && t.HospitalId == allot.HospitalId)
                    ?? _cofdrugtypefactorRepository.GetEntities(t => t.AllotID == -1);
                if (drugTypeFactors != null && drugTypeFactors.Any())
                {
                    var newDrugtypeFactors = drugTypeFactors.Select(t => new cof_drugtype_factor
                    {
                        HospitalId = allot.HospitalId,
                        AllotID = allot.ID,
                        ExModuleId = t.ExModuleId,
                        Charge = t.Charge,
                        YSZ = t.YSZ,
                        HLZ = t.HLZ,
                        YJZ = t.YJZ
                    });
                    _cofdrugtypefactorRepository.AddRange(newDrugtypeFactors.ToArray());
                }
            }
        }


        public void Copy_DeptTypes(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy deptTypes");
            var deptTypes = _perforCofdepttypeRepository.GetEntities(t => t.AllotID == allot.ID);
            if (delHistotyData && deptTypes != null && deptTypes.Any())
                flag = _perforCofdepttypeRepository.RemoveRange(deptTypes.ToArray());
            if (flag || deptTypes == null || !deptTypes.Any())
            {
                deptTypes = _perforCofdepttypeRepository.GetEntities(t => t.AllotID == prevAllotId) ?? _perforCofdepttypeRepository.GetEntities(t => t.AllotID == -1);
                if (deptTypes != null && deptTypes.Any())
                {
                    var newDeptTypes = deptTypes.Select(t => new cof_depttype { AllotID = allot.ID, Charge = t.Charge, ChargeType = t.ChargeType });
                    _perforCofdepttypeRepository.AddRange(newDeptTypes.ToArray());
                }
            }
        }


        public void Copy_Agains(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy agains");
            var agains = _againRepository.GetEntities(t => t.AllotID == allot.ID);
            if (delHistotyData && agains != null && agains.Any())
                flag = _againRepository.RemoveRange(agains.ToArray());
            if (flag || agains == null || !agains.Any())
            {
                agains = _againRepository.GetEntities(t => t.AllotID == prevAllotId) ?? _againRepository.GetEntities(t => t.AllotID == -1);
                if (agains != null && agains.Any())
                {
                    var days = allot.Month >= 1 && allot.Month <= 12 ? DateTime.DaysInMonth(allot.Year, allot.Month) : 30m;
                    var newAgains = agains.Select(t => new cof_again
                    {
                        AllotID = allot.ID,
                        Type = t.Type,
                        Department = t.Department,
                        TypeName = t.TypeName,
                        Value = t.TypeName == "满勤天数" ? days : t.Value
                    });
                    _againRepository.AddRange(newAgains.ToArray());
                }
            }
        }


        public void Copy_Accountings(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy accountings");
            var accountings = _cofaccountingRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && accountings != null && accountings.Any())
                flag = _cofaccountingRepository.RemoveRange(accountings.ToArray());
            if (flag || accountings == null || !accountings.Any())
            {
                accountings = _cofaccountingRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _cofaccountingRepository.GetEntities(t => t.AllotId == -1);
                if (accountings != null && accountings.Any())
                {
                    var newAccountings = accountings.Select(t => new cof_accounting
                    {
                        AllotId = allot.ID,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        Code = t.Code,
                        IsVerify = t.IsVerify,
                        VerifyMessage = t.VerifyMessage
                    });
                    _cofaccountingRepository.AddRange(newAccountings.ToArray());
                }
            }
        }


        public void Copy_DeptDic(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy per_dept_dic");
            var deptDic = _perdeptdicRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && deptDic != null && deptDic.Any())
                flag = _perdeptdicRepository.RemoveRange(deptDic.ToArray());
            if (flag || deptDic == null || !deptDic.Any())
            {
                deptDic = _perdeptdicRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perdeptdicRepository.GetEntities(t => t.AllotId == -1);
                if (deptDic != null && deptDic.Any())
                {
                    var newDeptDic = deptDic.Select(t => new per_dept_dic
                    {
                        AllotId = allot.ID,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        CreateTime = t.CreateTime,
                        CreateUser = t.CreateUser,
                        Department = t.Department,
                        HISDeptName = t.HISDeptName,
                        HospitalId = t.HospitalId,
                        Source = t.Source,
                        IsVerify = t.IsVerify,
                        VerifyMessage = t.VerifyMessage
                    });
                    _perdeptdicRepository.AddRange(newDeptDic.ToArray());
                }
            }
        }

        public void Copy_AttendanceType(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy attendanceType");
            var UpdateattendanceTypes = _pperAttendanceTypeRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && UpdateattendanceTypes != null && UpdateattendanceTypes.Any())
                UpdateattendanceTypes.ForEach(t => t.AllotId = 0);
            flag = _pperAttendanceTypeRepository.UpdateRange(UpdateattendanceTypes.ToArray());
            var attendanceTypes = _pperAttendanceTypeRepository.GetEntities(t => t.AllotId == allot.ID);
            if (flag || attendanceTypes == null || !attendanceTypes.Any())
            {
                attendanceTypes = _pperAttendanceTypeRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _pperAttendanceTypeRepository.GetEntities(t => t.AllotId == -1);
                if (attendanceTypes != null && attendanceTypes.Any())
                {
                    var newAttendanceTypes = attendanceTypes.Select(t => new per_attendance_type
                    {
                        AllotId = allot.ID,
                        AttendanceName = t.AttendanceName,
                        HospitalId = t.HospitalId,
                        IsDeduction = t.IsDeduction
                    });
                    _pperAttendanceTypeRepository.AddRange(newAttendanceTypes.ToArray());
                }
            }
            var attendanceDepts = _perforPerAttendanceDeptRepository.GetEntities(t => t.AllotId == allot.ID);
            var attendanceTypess = _pperAttendanceTypeRepository.GetEntities(t => t.AllotId == allot.ID || t.AllotId == 0);
            foreach (var item in attendanceDepts)
            {
                for (int i = 1; i <= 30; i++)
                {
                    int? dayValue = (int?)typeof(per_attendance_dept).GetProperty("Day" + i.ToString("D2"))?.GetValue(item);
                    if (dayValue != null && dayValue > 0)
                    {
                        string attendanceName = attendanceTypess.FirstOrDefault(t => t.Id == dayValue)?.AttendanceName;
                        if (!string.IsNullOrEmpty(attendanceName))
                        {
                            int? attendanceId = attendanceTypess.FirstOrDefault(w => w.AttendanceName == attendanceName && w.AllotId == allot.ID)?.Id;
                            if (attendanceId != null)
                            {
                                typeof(per_attendance_dept).GetProperty("Day" + i.ToString("D2"))?.SetValue(item, attendanceId);
                            }
                        }
                    }
                }

            }
            flag = _perforPerAttendanceDeptRepository.UpdateRange(attendanceDepts.ToArray());
            if (flag) { attendanceTypess = attendanceTypess.Where(t => t.AllotId == 0).ToList(); _pperAttendanceTypeRepository.RemoveRange(attendanceTypess.ToArray()); }
        }

        public void Copy_AssessType(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy assessType");
            var aCategory = _perforPerAssessCategoryRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && aCategory != null && aCategory.Any())
                flag = _perforPerAssessCategoryRepository.RemoveRange(aCategory.ToArray());
            var aScheme = _perforPerAssessSchemeRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && aScheme != null && aScheme.Any())
                flag = _perforPerAssessSchemeRepository.RemoveRange(aScheme.ToArray());
            var aSchemeItems = _perforPerAssessSchemeItemsRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && aSchemeItems != null && aSchemeItems.Any())
                flag = _perforPerAssessSchemeItemsRepository.RemoveRange(aSchemeItems.ToArray());
            var aSchemeTarget = _perforPerAssessSchemeTargetRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && aSchemeTarget != null && aSchemeTarget.Any())
                flag = _perforPerAssessSchemeTargetRepository.RemoveRange(aSchemeTarget.ToArray());
            var aIssueScheme = _perforPerAssessIssueSchemeRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && aIssueScheme != null && aIssueScheme.Any())
                flag = _perforPerAssessIssueSchemeRepository.RemoveRange(aIssueScheme.ToArray());
            var dateTimeNow = DateTime.Now;

            if (flag || aCategory == null || !aCategory.Any())
            {
                aCategory = _perforPerAssessCategoryRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perforPerAssessCategoryRepository.GetEntities(t => t.AllotId == -1);
                if (aCategory != null && aCategory.Any())
                {
                    var newaCategorys = aCategory.Select(t => new per_assess_category
                    {
                        Id = 0,
                        AllotId = allot.ID,
                        AssessCode = t.AssessCode,
                        AssessName = t.AssessName,
                        CreateBy = t.CreateBy,
                        CreateTime = dateTimeNow,
                        UpdateBy = t.UpdateBy,
                        UpdateTime = dateTimeNow,
                    });
                    var aCategoryTemp = _perforPerAssessCategoryRepository.AddRange(newaCategorys.ToArray());
                    //if (!aCategoryTemp) throw new PerformanceException("考核分类未继承成功，请检查后在尝试！");
                }
            }
            var aCategoryss = _perforPerAssessCategoryRepository.GetEntities(t => t.AllotId == allot.ID);
            if (flag || aScheme == null || !aScheme.Any())
            {
                aScheme = _perforPerAssessSchemeRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perforPerAssessSchemeRepository.GetEntities(t => t.AllotId == -1);
                if (aScheme != null && aScheme.Any())
                {
                    var newaSchemes = aScheme.Select(t => new per_assess_scheme
                    {
                        Id = 0,
                        AllotId = allot.ID,
                        AssessId = aCategoryss.FirstOrDefault(w => w.AssessCode == aCategory.FirstOrDefault(s => s.Id == t.AssessId).AssessCode && w.AllotId == allot.ID).Id,
                        SchemeCode = t.SchemeCode,
                        SchemeName = t.SchemeName,
                        SchemeRemarks = t.SchemeRemarks,
                        CreateBy = t.CreateBy,
                        CreateTime = dateTimeNow,
                        UpdateBy = t.UpdateBy,
                        UpdateTime = dateTimeNow,
                    });
                    var aSchemeTemp = _perforPerAssessSchemeRepository.AddRange(newaSchemes.ToArray());

                    // if (!aSchemeTemp) throw new PerformanceException("考核方案未继承成功，请检查后在尝试！");
                }
            }
            var aSchemes = _perforPerAssessSchemeRepository.GetEntities(t => t.AllotId == allot.ID);
            if (flag || aSchemeItems == null || !aSchemeItems.Any())
            {
                aSchemeItems = _perforPerAssessSchemeItemsRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perforPerAssessSchemeItemsRepository.GetEntities(t => t.AllotId == -1);
                if (aSchemeItems != null && aSchemeItems.Any())
                {
                    var newaSchemeItems = aSchemeItems.Select(t => new per_assess_scheme_items
                    {
                        Id = 0,
                        AllotId = allot.ID,
                        AssessId = aCategoryss.FirstOrDefault(w => w.AssessCode == aCategory.FirstOrDefault(s => s.Id == t.AssessId).AssessCode && w.AllotId == allot.ID).Id,
                        SchemeId = aSchemes.FirstOrDefault(w => w.SchemeCode == aScheme.FirstOrDefault(s => s.Id == t.SchemeId).SchemeCode && w.AllotId == allot.ID).Id,
                        ItemCode = t.ItemCode,
                        ItemName1 = t.ItemName1,
                        ItemName2 = t.ItemName2,
                        UnitCode = t.UnitCode,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        AssessNorm = t.AssessNorm,
                        AssessScore = t.AssessScore,
                        CreateBy = t.CreateBy,
                        CreateTime = dateTimeNow,
                        UpdateBy = t.UpdateBy,
                        UpdateTime = dateTimeNow,
                    });
                    var aSchemeItemsTemp = _perforPerAssessSchemeItemsRepository.AddRange(newaSchemeItems.ToArray());

                    // if (!aSchemeItemsTemp) throw new PerformanceException("考核方案指标未继承成功，请检查后在尝试！");
                }
            }
            var aSchemeItemss = _perforPerAssessSchemeItemsRepository.GetEntities(t => t.AllotId == allot.ID);
            if (flag || aSchemeTarget == null || !aSchemeTarget.Any())
            {
                aSchemeTarget = _perforPerAssessSchemeTargetRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perforPerAssessSchemeTargetRepository.GetEntities(t => t.AllotId == -1);
                if (aSchemeTarget != null && aSchemeTarget.Any())
                {
                    var newaSchemeTarget = aSchemeTarget.Select(t => new per_assess_scheme_target
                    {
                        Id = 0,
                        AllotId = allot.ID,
                        AssessId = aCategoryss.FirstOrDefault(w => w.AssessCode == aCategory.FirstOrDefault(s => s.Id == t.AssessId).AssessCode && w.AllotId == allot.ID).Id,
                        SchemeId = aSchemes.FirstOrDefault(w => w.SchemeCode == aScheme.FirstOrDefault(s => s.Id == t.SchemeId).SchemeCode && w.AllotId == allot.ID).Id,
                        UnitCode = t.UnitCode,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        CreateBy = t.CreateBy,
                        CreateTime = dateTimeNow,
                        UpdateBy = t.UpdateBy,
                        UpdateTime = dateTimeNow,
                    });
                    var aSchemeTargetTemp = _perforPerAssessSchemeTargetRepository.AddRange(newaSchemeTarget.ToArray());
                    // if (!aSchemeTargetTemp) throw new PerformanceException("考核对象未继承成功，请检查后在尝试！");
                }
            }

            if (flag || aIssueScheme == null || !aIssueScheme.Any())
            {
                aIssueScheme = _perforPerAssessIssueSchemeRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perforPerAssessIssueSchemeRepository.GetEntities(t => t.AllotId == -1);
                if (aIssueScheme != null && aIssueScheme.Any())
                {
                    var newaIssueSchemess = aIssueScheme.Select(t => new per_assess_issue_scheme
                    {
                        Id = 0,
                        AllotId = allot.ID,
                        AssessId = aCategoryss.FirstOrDefault(w => w.AssessCode == aCategory.FirstOrDefault(s => s.Id == t.AssessId).AssessCode && w.AllotId == allot.ID).Id,
                        AssessCode = t.AssessCode,
                        AssessName = t.AssessName,
                        SchemeId = aSchemes.FirstOrDefault(w => w.SchemeCode == aScheme.FirstOrDefault(s => s.Id == t.SchemeId).SchemeCode && w.AllotId == allot.ID).Id,
                        SchemeCode = t.SchemeCode,
                        SchemeName = t.SchemeName,
                        ItemId = aSchemeItemss.FirstOrDefault(w => w.ItemCode == aSchemeItems.FirstOrDefault(s => s.Id == t.ItemId).ItemCode && w.AllotId == allot.ID).Id,
                        ItemCode = t.ItemCode,
                        ItemName1 = t.ItemName1,
                        ItemName2 = t.ItemName2,
                        AssessNorm = t.AssessNorm,
                        AssessScore = t.AssessScore,
                        UnitCode = t.UnitCode,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        State = (int)Assess.AssessState.未提交,
                        CreateBy = t.CreateBy,
                        CreateTime = dateTimeNow,
                        UpdateBy = t.UpdateBy,
                        UpdateTime = dateTimeNow,
                        Score = null,
                        ScoreRemark = null,
                        TargetUnitCode = t.TargetUnitCode,
                        TargetUnitType = t.TargetUnitType,
                        TargetAccountingUnit = t.TargetAccountingUnit,
                        SubmitBy = null,
                        SubmitTime = null,
                        AuditBy = null,
                        AuditTime = null,
                        AuditRemark = null,
                    });
                    var aIssueSchemeTemp = _perforPerAssessIssueSchemeRepository.AddRange(newaIssueSchemess.ToArray());
                    // if (!aSchemeItemsTemp) throw new PerformanceException("考核下发未继承成功，请检查后在尝试！");
                }
            }
        }


    }
}
