//-----------------------------------------------------------------------
// <copyright file=" ag_secondallot.cs">
// * FileName: 二次绩效列表.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 二次绩效列表
    /// </summary>
    [Table("ag_secondallot")]
    public class ag_secondallot
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 绩效ID
        /// </summary>
        public Nullable<int> AllotId { get; set; }

        /// <summary>
        /// 使用模板
        /// </summary>
        public Nullable<int> UseTempId { get; set; }

        /// <summary>
        /// 科室类型
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 年
        /// </summary>
        public Nullable<int> Year { get; set; }

        /// <summary>
        /// 月
        /// </summary>
        public Nullable<int> Month { get; set; }

        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 科室实发金额
        /// </summary>
        public Nullable<decimal> RealGiveFee { get; set; }

        /// <summary>
        /// 预发金额
        /// </summary>
        public Nullable<decimal> PreRealGiveFee { get; set; }
        /// <summary>
        /// 效率绩效
        /// </summary>
        public Nullable<decimal> Efficiency { get; set; }

        /// <summary>
        /// 规模绩效
        /// </summary>
        public Nullable<decimal> Scale { get; set; }

        /// <summary>
        /// 发放系数
        /// </summary>
        public Nullable<decimal> Grant { get; set; }

        /// <summary>
        /// 应发管理绩效
        /// </summary>
        public Nullable<decimal> ShouldGiveFee { get; set; }

        /// <summary>
        /// 状态 1 未提交  2 等待审核 3 审核通过 4 驳回
        /// </summary>
        public Nullable<int> Status { get; set; }

        /// <summary>
        /// 提交类型 1使用模板 2 其他类型数据
        /// </summary>
        public Nullable<int> SubmitType { get; set; }

        /// <summary>
        /// 提交时间
        /// </summary>
        public Nullable<DateTime> SubmitTime { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public Nullable<DateTime> AuditTime { get; set; }

        /// <summary>
        /// 审核人
        /// </summary>
        public Nullable<int> AuditUser { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 护理部审核时间
        /// </summary>
        public Nullable<DateTime> NursingDeptAuditTime { get; set; }

        /// <summary>
        /// 护理部审核人
        /// </summary>
        public Nullable<int> NursingDeptAuditUser { get; set; }

        /// <summary>
        /// 护理部备注
        /// </summary>
        public string NursingDeptRemark { get; set; }

        /// <summary>
        /// 护理部审核状态 2 等待审核 3 审核通过 4 驳回
        /// </summary>
        public Nullable<int> NursingDeptStatus { get; set; }

        /// <summary>
        /// 夜班绩效
        /// </summary>
        public Nullable<decimal> NightShiftWorkPerforFee { get; set; }
    }
}
