//-----------------------------------------------------------------------
// <copyright file=" cost_transfer_item.cs">
// * FileName: .cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 
    /// </summary>
    [Table("cost_transfer_item")]
    public class cost_transfer_item
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int TransferId { get; set; }

        /// <summary>
        /// 来源，sheet名称
        /// </summary>
        public string Source { get; set; }

        /// <summary>
        /// 费用类型
        /// </summary>
        public string Category { get; set; }

        /// <summary>
        /// 金额
        /// </summary>
        public Nullable<decimal> Amount { get; set; }

        /// <summary>
        /// 分割比例
        /// </summary>
        public Nullable<decimal> Ratio { get; set; }

        /// <summary>
        /// 实际金额
        /// </summary>
        public Nullable<decimal> CalculationAmount { get; set; }

        /// <summary>
        /// 是否使用分割比例
        /// </summary>
        public int IsUseRatio { get; set; }
                
        /// <summary>
        /// 申请理由
        /// </summary>
        public string ApplicationRemark { get; set; }

        /// <summary>
        /// 科室备注
        /// </summary>
        public string DepartmentRemark { get; set; }

        /// <summary>
        /// 管理员备注
        /// </summary>
        public string AdminRemark { get; set; }
        
        /// <summary>
        /// 0 默认 1 通过 2 驳回 3 下发驳回 4 撤回
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 0 默认 1 通过 2 驳回 3 下发驳回 4 撤回
        /// </summary>
        public int AdminStatus { get; set; }

        /// <summary>
        /// 数据是否被写入
        /// </summary>
        public int IsWrited { get; set; }
    }
}
