﻿using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.DtoModels.Request;
using Performance.EntityModels;
using Performance.Services;

namespace Performance.Api.Controllers
{
    [Route("api")]
    public class MenuController : Controller
    {
        private MenuService _menuService;
        private ClaimService _claim;
        public MenuController(MenuService menuService, ClaimService claimService)
        {
            _menuService = menuService;
            _claim = claimService;
        }

        /// <summary>
        /// 用户登录后菜单列表
        /// </summary>
        /// <returns></returns>
        [Route("menu/menulist")]
        [HttpPost]
        public ApiResponse<List<MenuResponse>> MenuList()
        {
            var menuList = _menuService.GetMenuList(_claim.GetUserId());
            return new ApiResponse<List<MenuResponse>>(ResponseType.OK, menuList);
        }

        #region 菜单管理
        /// <summary>
        /// 菜单管理列表(树状结构)
        /// </summary>
        /// <returns></returns>
        [Route("system/menu")]
        [HttpPost]
        public ApiResponse<List<MenuResponse>> GetSystemMenu()
        {
            var getSystemMenu = _menuService.GetSystemMenu();
            return new ApiResponse<List<MenuResponse>>(ResponseType.OK, getSystemMenu);

        }

        /// <summary>
        /// 新增/新增子级
        /// </summary>
        /// <returns></returns>
        [Route("system/menu/add")]
        [HttpPost]
        public ApiResponse AddSystemMenu([FromBody] MenuRequest menuRequest)
        {
            return _menuService.AddSystemMenu(menuRequest);
        }

        /// <summary>
        /// 修改
        /// </summary>
        /// <returns></returns>
        [Route("system/menu/update")]
        [HttpPost]
        public ApiResponse UpdateSystemMenu([FromBody] MenuRequest menuRequest)
        {
            return _menuService.UpdateSystemMenu(menuRequest);
        }

        /// <summary>
        /// 删除
        /// </summary>
        /// <returns></returns>
        [Route("system/menu/delete")]
        [HttpPost]
        public ApiResponse DeleteSystemMenu(int menuID)
        {
            return _menuService.DeleteSystemMenu(menuID);
        }

        /// <summary>
        /// 当前菜单下的角色
        /// </summary>
        /// <returns></returns>
        [Route("system/menu/getrole")]
        [HttpPost]
        public ApiResponse<List<sys_role_menu>> GetRoleSystemMenu(int menuID)
        {
            return _menuService.GetRoleSystemMenu(menuID);
        }


        /// <summary>
        /// 设置角色
        /// </summary>
        /// <returns></returns>
        [Route("system/menu/setrole")]
        [HttpPost]
        public ApiResponse SetRoleSystemMenu([FromBody] RoleRequest roleRequest)
        {
            return _menuService.SetRoleSystemMenu(roleRequest);
        }
        #endregion

    }
}
