﻿using GraphQL.Types;
using Performance.DtoModels;

namespace Performance.Api
{
    public class ReportDataType : ObjectGraphType<ReportData>
    {
        public ReportDataType()
        {
            Field(x => x.ReportID, type: typeof(IdGraphType));
            Field(x => x.ChartType, nullable: true);
            Field(x => x.Sort, nullable: true);
            Field(x => x.Title);
            Field(x => x.QueryName);
            Field(x => x.QueryArguments);
            Field(x => x.XTitle);
            Field(x => x.XUnit);
            Field(x => x.YTitle);
            Field(x => x.YUnit);
            Field(x => x.VTitle);
            Field(x => x.VUnit);
            Field(x => x.NTitle);
            Field(x => x.NUnit);
            Field(x => x.Formula);
            Field(x => x.DataType, nullable: true);
            Field(x => x.FilterValue, nullable: true);
        }
    }
}
