﻿using FluentValidation;

namespace Performance.DtoModels
{
    public class WorkItemRequest
    {

        public int ID { get; set; }

        public int AllotID { get; set; }
        /// <summary>
        /// 工作量绩效项
        /// </summary>
        public string Item { get; set; }

        /// <summary>
        /// 1. 药占比 2. CMI
        /// </summary>
        public int Type { get; set; }
        public int CurrentPage { get; set; } = 0;
        public int PageSize { get; set; } = 0;
    }
    public class WorkItemRequestValidator : AbstractValidator<WorkItemRequest>
    {
        public WorkItemRequestValidator()
        {
            RuleSet("Select", () =>
            {
                RuleFor(x => x.AllotID).NotNull().NotEmpty().GreaterThan(0);
            });

            RuleSet("Insert", () =>
            {
                RuleFor(x => x.AllotID).NotNull().GreaterThan(0);
                RuleFor(x => x.Type).NotNull().GreaterThan(0);
            });

            RuleSet("Update", () =>
            {
                RuleFor(x => x.ID).NotNull().GreaterThan(0);
                RuleFor(x => x.Type).NotNull().GreaterThan(0);
            });

            RuleSet("Delete", () =>
            {
                RuleFor(x => x.ID).NotNull().GreaterThan(0);
            });
        }
    }
}
