﻿using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class DeptDetailResponse
    {
        public PerDataAccountBaisc Pandect { get; set; }
        public List<DeptDetail> Economic { get; set; }
        public List<DeptDetail> Workload { get; set; }
    }

    public class DeptDetail
    {
        public string ItemName { get; set; }
        public decimal ItemValue { get; set; }
    }


    public class DeptDataDetails<T>
    {
        /// <summary> 概览</summary>
        public PerDataAccountBaisc Pandect { get; set; }

        /// <summary> 收入明细 </summary>
        public List<DetailDtos<T>> Detail { get; set; }

        /// <summary> 0 不显示 1 显示 </summary>
        public int ShowFormula { get; set; }
    }

    public class DeptDataDetails
    {
        /// <summary> 概览</summary>
        public PerDataAccountBaisc Pandect { get; set; }

        /// <summary> 收入明细 </summary>
        public List<DetailDtos> Detail { get; set; }

        /// <summary> 0 不显示 1 显示 </summary>
        public int ShowFormula { get; set; }
    }

    public class DetailDtos<T>
    {
        /// <summary> 收入项名称 </summary>
        public string ItemName { get; set; }

        /// <summary> 1、收入 2、支出 3、工作量 4、特殊科室 5、科室奖罚 6、科室药占比考核 7、科室材料占比考核 8、调节后其他绩效 9、行政工勤 </summary>
        public int IncomeType { get; set; }
        /// <summary> 原始SheetType </summary>
        public int OriginalType { get; set; }
        /// <summary> 金额 </summary>
        public decimal Amount { get; set; }

        /// <summary> 详情 </summary>
        public List<T> Items { get; set; }

        /// <summary> 分组依据 </summary>
        public int GroupBasis { get; set; }
    }

    public class DetailDtos : DetailDtos<DetailModule>
    {

    }

    public class DetailModule
    {
        /// <summary> 工号 </summary>
        public string JobNumber { get; set; }
        /// <summary> 明细项 </summary>
        public string ItemName { get; set; }

        /// <summary> 原始值 </summary>
        public decimal? CellValue { get; set; }

        /// <summary> 系数 </summary>
        public decimal? Factor { get; set; }

        /// <summary> 药占比系数 </summary>
        public decimal? MediFactor { get; set; }

        /// <summary> CMI系数 </summary>
        public decimal? CMIFactor { get; set; }

        /// <summary> 工作量倾斜系数 </summary>
        public decimal? InclineFactor { get; set; }

        /// <summary> 结算值 </summary>
        public decimal? ItemValue { get; set; }
        public decimal? OtherPerfor { get; set; }
        public decimal? Attendance { get; set; }
        public decimal? PostCoefficient { get; set; }
    }

    public class DetailModuleExtend : DetailModule
    {
        /// <summary> 原始值 </summary>
        public decimal? CellValue2 { get; set; }

        /// <summary> 系数 </summary>
        public decimal? Factor2 { get; set; }

        /// <summary> 结算值 </summary>
        public decimal? ItemValue2 { get; set; }

    }
}
