﻿using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class UniteDeptDetailResponse
    {
        public string Title { get; set; }
        public string UnitType { get; set; }
        public string AccountingUnit { get; set; }
        /// <summary> 0 不显示 1 显示 </summary>
        public int ShowFormula { get; set; }
        public List<DeptDetailItem> DetailItems { get; set; }

    }
    public class DeptDetailItem
    {
        /// <summary>
        /// 显示标题
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// 总额
        /// </summary>
        public decimal Total { get; set; }
        /// <summary>
        /// 格式化后总额
        /// </summary>
        public string TotalFormat { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
        /// <summary>
        /// 排序
        /// </summary>
        public int Sort { get; set; }
        /// <summary>
        /// 是否显示
        /// </summary>
        public bool Display { get; set; } = true;
        /// <summary>
        /// 背景颜色突出
        /// </summary>
        public bool StandOut { get; set; } = false;
        /// <summary>
        /// 原始Sheet类型
        /// </summary>
        public SheetType SheetType { get; set; }
        public List<DeptDetailItem> Children { get; set; }
        public List<Dictionary<string, object>> Items { get; set; }
    }
}
