﻿using System;
using Performance.EntityModels.Entity;

namespace Performance.EntityModels.Other
{
    public class view_attendance
    {
        public int ALLOTID { get; set; }
        public int YEAR { get; set; }
        public int MONTH { get; set; }
        public int Id { get; set; } = 0;
        /// <summary>
        /// 人员类别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 工号
        /// </summary>
        public string PersonnelNumber { get; set; }
        /// <summary>
        /// 姓名
        /// </summary>
        public string PersonnelName { get; set; }
        /// <summary>
        /// 人员系数
        /// </summary>
        public decimal? PermanentStaff { get; set; }
        /// <summary>
        /// 考勤时间
        /// </summary>
        public DateTime AttendanceDate { get; set; }
        /// <summary>
        /// 来源
        /// </summary>
        public string Source { get; set; }
        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }
    }

    public class InitialAttendance
    {
        public string UnitType { get; set; } //人员类别
        public string AccountingUnit { get; set; } //核算单元
        public string PersonnelNumber { get; set; } //工号
        public string PersonnelName { get; set; } //姓名
        public Nullable<DateTime> StartDate { get; set; } //入科开始时间
        public Nullable<DateTime> EndDate { get; set; } //入科结束时间
        public string Department { get; set; } //科室名称
    }
    public class RecordAttendcance : per_attendance_vacation
    {
        public int Days { get; set; }
        public string AttendanceName { get; set; }
    }


    public class AttendaceHeads
    {
        public string Column { get; set; }
        public string Name { get; set; }

    }

    public class AttendanceType
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; } //考勤类型名称
        /// <summary>
        /// 考勤类型名称
        /// </summary>
        public string AttendanceName { get; set; }
        /// <summary>
        /// 是否核减出勤 0 不核减 1 核减
        /// </summary>
        public int IsDeduction { get; set; }
        /// <summary>
        /// 是否默认值  0 非默认 1 默认
        /// </summary>
        public int IsDefault { get; set; }
    }
}
