//-----------------------------------------------------------------------
// <copyright file=" im_employee_logistics.cs">
// * FileName: im_employee_logistics.cs
// </copyright>
//-----------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using Performance.EntityModels;

namespace Performance.Repository
{
    /// <summary>
    /// im_employee_logistics Repository
    /// </summary>
    public partial class PerforImemployeelogisticsRepository : PerforRepository<im_employee_logistics>
    {
        public List<im_employee_logistics> GetEmployees(int allotId)
        {
            return context.Set<im_employee_logistics>()
                 .Where(w => w.AllotID == allotId)
                 .ToList()
                 .GroupBy(w => new { w.PersonnelNumber, w.AccountingUnit })
                 .Select(w => w.OrderByDescending(p => p.ID).First())
                 .ToList()
                 ?? new List<im_employee_logistics>();
        }
    }
}
