﻿using Microsoft.Extensions.Logging;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.EntityModels.Entity;
using Performance.Repository;
using Performance.Repository.Repository;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Performance.Services
{
    public class CopyService : IAutoInjection
    {
        private readonly ILogger<ConfigService> _logger;
        private readonly PerforPerdeptdicRepository _perdeptdicRepository;
        private readonly PerforCofworkitemRepository _workitemRepository;
        private readonly PerforCofagainRepository _againRepository;
        private readonly PerforCofdrugtypeRepository _drugtypeRepository;
        private readonly PerforCofdepttypeRepository _perforCofdepttypeRepository;
        private readonly PerforCofaccountingRepository _cofaccountingRepository;
        private readonly PerforCofdrugtypeDisburseRepository _drugtypeDisburseRepository;
        private readonly PerforCofdrugtypefactorRepository _cofdrugtypefactorRepository;
        private readonly PerfoPperAttendanceTypeRepository _pperAttendanceTypeRepository;
        private readonly PerforPerAssessCategoryRepository _perforPerAssessCategoryRepository;
        private readonly PerforPerAssessSchemeRepository _perforPerAssessSchemeRepository;
        private readonly PerforPerAssessSchemeItemsRepository _perforPerAssessSchemeItemsRepository;
        private readonly PerforPerAssessSchemeTargetRepository _perforPerAssessSchemeTargetRepository;
        private readonly PerforPerAssessIssueSchemeRepository _perforPerAssessIssueSchemeRepository;
        private readonly PerforPerAttendanceDeptRepository _perforPerAttendanceDeptRepository;
        private readonly PerforCofDeptDetailRepository _perforCofDeptDetailRepository;
        private readonly PerforCofEmpDetailRepository _perforCofEmpDetailRepository;
        private readonly PerforPeremployeeRepository _perforPeremployeeRepository;

        public CopyService(
            ILogger<ConfigService> logger,
            PerforPerdeptdicRepository perdeptdicRepository,
            PerforCofagainRepository againRepository,
            PerforCofdrugtypeRepository drugtypeRepository,
            PerforCofworkitemRepository workitemRepository,
            PerforCofdepttypeRepository perforCofdepttypeRepository,
            PerforCofaccountingRepository cofaccountingRepository,
            PerforCofdrugtypeDisburseRepository drugtypeDisburseRepository,
            PerforCofdrugtypefactorRepository cofdrugtypefactorRepository,
            PerfoPperAttendanceTypeRepository pperAttendanceTypeRepository,
            PerforPerAssessCategoryRepository perforPerAssessCategoryRepository,
            PerforPerAssessSchemeRepository perforPerAssessSchemeRepository,
            PerforPerAssessSchemeItemsRepository perforPerAssessSchemeItemsRepository,
            PerforPerAssessSchemeTargetRepository perforPerAssessSchemeTargetRepository,
            PerforPerAssessIssueSchemeRepository perforPerAssessIssueSchemeRepository,
            PerforPerAttendanceDeptRepository perforPerAttendanceDeptRepository,
            PerforCofDeptDetailRepository perforCofDeptDetailRepository,
            PerforCofEmpDetailRepository perforCofEmpDetailRepository,
            PerforPeremployeeRepository perforPeremployeeRepository
            )
        {
            _logger = logger;
            _perdeptdicRepository = perdeptdicRepository;
            _workitemRepository = workitemRepository;
            _againRepository = againRepository;
            _drugtypeRepository = drugtypeRepository;
            _perforCofdepttypeRepository = perforCofdepttypeRepository;
            _cofaccountingRepository = cofaccountingRepository;
            _drugtypeDisburseRepository = drugtypeDisburseRepository;
            _cofdrugtypefactorRepository = cofdrugtypefactorRepository;
            _pperAttendanceTypeRepository = pperAttendanceTypeRepository;
            _perforPerAssessCategoryRepository = perforPerAssessCategoryRepository;
            _perforPerAssessSchemeRepository = perforPerAssessSchemeRepository;
            _perforPerAssessSchemeItemsRepository = perforPerAssessSchemeItemsRepository;
            _perforPerAssessSchemeTargetRepository = perforPerAssessSchemeTargetRepository;
            _perforPerAssessIssueSchemeRepository = perforPerAssessIssueSchemeRepository;
            _perforPerAttendanceDeptRepository = perforPerAttendanceDeptRepository;
            _perforCofDeptDetailRepository = perforCofDeptDetailRepository;
            _perforCofEmpDetailRepository = perforCofEmpDetailRepository;
            _perforPeremployeeRepository = perforPeremployeeRepository;
        }


        public void Copy_WorkItems(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy workItems");
            var workItems = _workitemRepository.GetEntities(t => t.AllotID == allot.ID);
            if (delHistotyData && workItems != null && workItems.Any())
                flag = _workitemRepository.RemoveRange(workItems.ToArray());
            if (flag || workItems == null || !workItems.Any())
            {
                workItems = _workitemRepository.GetEntities(t => t.AllotID == prevAllotId) ?? _workitemRepository.GetEntities(t => t.AllotID == -1);
                if (workItems != null && workItems.Any())
                {
                    var newWorkItems = workItems.Select(t => new cof_workitem { AllotID = allot.ID, Type = t.Type, Item = t.Item });
                    _workitemRepository.AddRange(newWorkItems.ToArray());
                }
            }
        }


        public void Copy_DrugTypes(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy drugTypes");
            var drugTypes = _drugtypeRepository.GetEntities(t => t.AllotID == allot.ID && t.HospitalId == allot.HospitalId);
            if (delHistotyData && drugTypes != null && drugTypes.Any())
                flag = _drugtypeRepository.RemoveRange(drugTypes.ToArray());
            if (flag || drugTypes == null || !drugTypes.Any())
            {
                drugTypes = _drugtypeRepository.GetEntities(t => t.AllotID == prevAllotId && t.HospitalId == allot.HospitalId) ?? _drugtypeRepository.GetEntities(t => t.AllotID == -1);
                if (drugTypes != null && drugTypes.Any())
                {
                    var newDrugTypes = drugTypes.Select(t => new cof_drugtype { HospitalId = allot.HospitalId, AllotID = allot.ID, Charge = t.Charge, ChargeType = t.ChargeType });
                    _drugtypeRepository.AddRange(newDrugTypes.ToArray());
                }
            }
        }


        public void Copy_DrugTypeDisburses(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy drugTypeDisburses");
            var drugTypeDisburses = _drugtypeDisburseRepository.GetEntities(t => t.AllotID == allot.ID && t.HospitalId == allot.HospitalId);
            if (delHistotyData && drugTypeDisburses != null && drugTypeDisburses.Any())
                flag = _drugtypeDisburseRepository.RemoveRange(drugTypeDisburses.ToArray());
            if (flag || drugTypeDisburses == null || !drugTypeDisburses.Any())
            {
                drugTypeDisburses = _drugtypeDisburseRepository.GetEntities(t => t.AllotID == prevAllotId && t.HospitalId == allot.HospitalId)
                    ?? _drugtypeDisburseRepository.GetEntities(t => t.AllotID == -1);
                if (drugTypeDisburses != null && drugTypeDisburses.Any())
                {
                    var newDrugTypeDisburses = drugTypeDisburses.Select(t => new cof_drugtype_disburse { HospitalId = allot.HospitalId, AllotID = allot.ID, Charge = t.Charge, ChargeType = t.ChargeType });
                    _drugtypeDisburseRepository.AddRange(newDrugTypeDisburses.ToArray());
                }
            }
        }


        public void Copy_DrugTypeFactors(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            Copy_DrugTypes(allot, prevAllotId, delHistotyData);

            var flag = delHistotyData;
            _logger.LogInformation($"copy drugTypeFactors");
            var drugTypeFactors = _cofdrugtypefactorRepository.GetEntities(t => t.AllotID == allot.ID && t.HospitalId == allot.HospitalId);
            if (delHistotyData && drugTypeFactors != null && drugTypeFactors.Any())
                flag = _cofdrugtypefactorRepository.RemoveRange(drugTypeFactors.ToArray());
            if (flag || drugTypeFactors == null || !drugTypeFactors.Any())
            {
                drugTypeFactors = _cofdrugtypefactorRepository.GetEntities(t => t.AllotID == prevAllotId && t.HospitalId == allot.HospitalId)
                    ?? _cofdrugtypefactorRepository.GetEntities(t => t.AllotID == -1);
                if (drugTypeFactors != null && drugTypeFactors.Any())
                {
                    var newDrugtypeFactors = drugTypeFactors.Select(t => new cof_drugtype_factor
                    {
                        HospitalId = allot.HospitalId,
                        AllotID = allot.ID,
                        ExModuleId = t.ExModuleId,
                        Charge = t.Charge,
                        YSZ = t.YSZ,
                        HLZ = t.HLZ,
                        YJZ = t.YJZ
                    });
                    _cofdrugtypefactorRepository.AddRange(newDrugtypeFactors.ToArray());
                }
            }
        }


        public void Copy_DeptTypes(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy deptTypes");
            var deptTypes = _perforCofdepttypeRepository.GetEntities(t => t.AllotID == allot.ID);
            if (delHistotyData && deptTypes != null && deptTypes.Any())
                flag = _perforCofdepttypeRepository.RemoveRange(deptTypes.ToArray());
            if (flag || deptTypes == null || !deptTypes.Any())
            {
                deptTypes = _perforCofdepttypeRepository.GetEntities(t => t.AllotID == prevAllotId) ?? _perforCofdepttypeRepository.GetEntities(t => t.AllotID == -1);
                if (deptTypes != null && deptTypes.Any())
                {
                    var newDeptTypes = deptTypes.Select(t => new cof_depttype { AllotID = allot.ID, Charge = t.Charge, ChargeType = t.ChargeType });
                    _perforCofdepttypeRepository.AddRange(newDeptTypes.ToArray());
                }
            }
        }


        public void Copy_Agains(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy agains");
            var agains = _againRepository.GetEntities(t => t.AllotID == allot.ID);
            if (delHistotyData && agains != null && agains.Any())
                flag = _againRepository.RemoveRange(agains.ToArray());
            if (flag || agains == null || !agains.Any())
            {
                agains = _againRepository.GetEntities(t => t.AllotID == prevAllotId) ?? _againRepository.GetEntities(t => t.AllotID == -1);
                if (agains != null && agains.Any())
                {
                    var days = allot.Month >= 1 && allot.Month <= 12 ? DateTime.DaysInMonth(allot.Year, allot.Month) : 30m;
                    var newAgains = agains.Select(t => new cof_again
                    {
                        AllotID = allot.ID,
                        Type = t.Type,
                        Department = t.Department,
                        TypeName = t.TypeName,
                        Value = t.TypeName == "满勤天数" ? days : t.Value
                    });
                    _againRepository.AddRange(newAgains.ToArray());
                }
            }
        }


        public void Copy_Accountings(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy accountings");
            var accountings = _cofaccountingRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && accountings != null && accountings.Any())
                flag = _cofaccountingRepository.RemoveRange(accountings.ToArray());
            if (flag || accountings == null || !accountings.Any())
            {
                accountings = _cofaccountingRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _cofaccountingRepository.GetEntities(t => t.AllotId == -1);
                if (accountings != null && accountings.Any())
                {
                    var newAccountings = accountings.Select(t => new cof_accounting
                    {
                        AllotId = allot.ID,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        Code = t.Code,
                        IsVerify = t.IsVerify,
                        VerifyMessage = t.VerifyMessage
                    });
                    _cofaccountingRepository.AddRange(newAccountings.ToArray());
                }
            }
        }


        public void Copy_DeptDic(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy per_dept_dic");
            var deptDic = _perdeptdicRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && deptDic != null && deptDic.Any())
                flag = _perdeptdicRepository.RemoveRange(deptDic.ToArray());
            if (flag || deptDic == null || !deptDic.Any())
            {
                deptDic = _perdeptdicRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perdeptdicRepository.GetEntities(t => t.AllotId == -1);
                if (deptDic != null && deptDic.Any())
                {
                    var newDeptDic = deptDic.Select(t => new per_dept_dic
                    {
                        AllotId = allot.ID,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        CreateTime = t.CreateTime,
                        CreateUser = t.CreateUser,
                        Department = t.Department,
                        HISDeptName = t.HISDeptName,
                        HospitalId = t.HospitalId,
                        Source = t.Source,
                        IsVerify = t.IsVerify,
                        VerifyMessage = t.VerifyMessage
                    });
                    _perdeptdicRepository.AddRange(newDeptDic.ToArray());
                }
            }
        }
        public void Copy_Deptdetail(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy cof_dept_detail");
            var cofDeptDetail = _perforCofDeptDetailRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && cofDeptDetail != null && cofDeptDetail.Any())
                flag = _perforCofDeptDetailRepository.RemoveRange(cofDeptDetail.ToArray());
            if (flag || cofDeptDetail == null || !cofDeptDetail.Any())
            {
                cofDeptDetail = _perforCofDeptDetailRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perforCofDeptDetailRepository.GetEntities(t => t.AllotId == -1);
                if (cofDeptDetail != null && cofDeptDetail.Any())
                {
                    var newCofDeptDetail = cofDeptDetail.Select(t => new cof_dept_detail
                    {
                        AllotId = allot.ID,
                        CreateTime = DateTime.Now,
                        Settings = t.Settings,
                    });
                    _perforCofDeptDetailRepository.AddRange(newCofDeptDetail.ToArray());
                }
            }
        }
        public void Copy_Empdetail(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy cof_emp_detail");
            var cofDeptDetail = _perforCofEmpDetailRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && cofDeptDetail != null && cofDeptDetail.Any())
                flag = _perforCofEmpDetailRepository.RemoveRange(cofDeptDetail.ToArray());
            if (flag || cofDeptDetail == null || !cofDeptDetail.Any())
            {
                cofDeptDetail = _perforCofEmpDetailRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perforCofEmpDetailRepository.GetEntities(t => t.AllotId == -1);
                if (cofDeptDetail != null && cofDeptDetail.Any())
                {
                    var newCofDeptDetail = cofDeptDetail.Select(t => new cof_emp_detail
                    {
                        AllotId = allot.ID,
                        CreateTime = DateTime.Now,
                        Settings = t.Settings,
                    });
                    _perforCofEmpDetailRepository.AddRange(newCofDeptDetail.ToArray());
                }
            }
        }
        /// <summary>
        /// 加载上月（考勤类型 --- 考勤上报详情）
        /// </summary>
        /// <param name="allot">当前绩效</param>
        /// <param name="prevAllotId">上月绩效Id</param>
        public void Copy_AttendanceType(per_allot allot, int prevAllotId)
        {
            _logger.LogInformation($"copy attendanceType");
            var attendanceTypes = _pperAttendanceTypeRepository.GetEntities(g => g.AllotId == prevAllotId || g.AllotId == allot.ID) ?? new List<per_attendance_type>();
            //查询上月有没有类型，没有就跳过
            var prevAttTypes = attendanceTypes.Where(w => w.AllotId == prevAllotId).ToList();
            if (!prevAttTypes.Any()) return;

            // 删除当月的考勤类型
            var delAttTypes = attendanceTypes.Where(w => w.AllotId == allot.ID).ToList();
            if (delAttTypes.Any())
            {
                _pperAttendanceTypeRepository.RemoveRange(delAttTypes.ToArray());
            }
            //插入上月的考勤类型
            var newAttTypes = prevAttTypes.Select(t => new per_attendance_type
            {
                AllotId = allot.ID,
                AttendanceName = t.AttendanceName,
                HospitalId = t.HospitalId,
                IsDeduction = t.IsDeduction,
                IsDefault = t.IsDefault,
            }).ToList();
            var successfulType = _pperAttendanceTypeRepository.AddRange(newAttTypes.ToArray());
            if (successfulType)
            {
                var prevPerEmployee = _perforPeremployeeRepository.GetEntities(g => g.AllotId == prevAllotId);
                if (!prevPerEmployee.Any()) return;

                // 删除当月的考勤上报
                var delAttDepts = _perforPerAttendanceDeptRepository.GetEntities(w => w.AllotId == allot.ID).ToList();
                if (delAttDepts.Any())
                {
                    _perforPerAttendanceDeptRepository.RemoveRange(delAttDepts.ToArray());
                }
                //查询默认考勤类型
                var typeDefault = newAttTypes.Find(f => f.IsDefault == (int)Attendance.Default.默认);
                var cofaccounting = _cofaccountingRepository.GetEntities(g => g.AllotId == prevAllotId);
                int currentMonth = DateTime.DaysInMonth(allot.Year, allot.Month);
                var newAttDepts = prevPerEmployee.Select(t =>
                {
                    var code = cofaccounting
                                .Where(p => p.UnitType == t.UnitType && p.AccountingUnit == t.AccountingUnit)
                                .Select(p => p.Code)
                                .FirstOrDefault() ?? "";
                    var newDept = new per_attendance_dept
                    {
                        HospitalId = t.HospitalId,
                        AllotId = allot.ID,
                        PersonnelName = t.DoctorName,
                        PersonnelNumber = t.PersonnelNumber,
                        PermanentStaff = t.PermanentStaff ?? 0,
                        Code = code,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        State = (int)Attendance.Report.未提交
                    };

                    for (int i = 1; i <= currentMonth; i++)
                    {
                        typeof(per_attendance_dept).GetProperty($"Day{i:d2}")?.SetValue(newDept, typeDefault.Id);
                    }

                    return newDept;
                }).ToList();

                _perforPerAttendanceDeptRepository.AddRange(newAttDepts.ToArray());
            }
        }
        /// <summary>
        /// 加载上月绩效考核
        /// </summary>
        /// <param name="allot"></param>
        /// <param name="prevAllotId"></param>
        public void Copy_AssessType(per_allot allot, int prevAllotId)
        {
            _logger.LogInformation($"copy assessType");
            var operatingTime = DateTime.Now;
            #region 考核类型加载上月
            //查询本月和上月的类型
            var perAssCategorys = _perforPerAssessCategoryRepository.GetEntities(t => t.AllotId == allot.ID || t.AllotId == prevAllotId);
            //查询上月有没有类型，没有就跳过
            var prevassCategorys = perAssCategorys.Where(w => w.AllotId == prevAllotId).ToList();
            if (!prevassCategorys.Any()) return;
            //查询本月类型，如果存在就改为-1
            var assCategorys = perAssCategorys.Where(w => w.AllotId == allot.ID).ToList();
            if (assCategorys.Any())
            {
                assCategorys.ForEach(w => { w.AllotId = -1; w.UpdateTime = operatingTime; });
                _perforPerAssessCategoryRepository.UpdateRange(assCategorys.ToArray());
            }
            //将上月的加载到本月
            var newassCategorys = prevassCategorys.Select(t => new per_assess_category
            {
                Id = 0,
                AllotId = allot.ID,
                AssessCode = t.AssessCode,
                AssessName = t.AssessName,
                CreateBy = t.CreateBy,
                CreateTime = operatingTime,
                UpdateBy = t.UpdateBy,
                UpdateTime = operatingTime,
            }).ToArray();
            _perforPerAssessCategoryRepository.AddRange(newassCategorys);
            #endregion
            //查询插入的考核类型
            var newperAssCategorys = _perforPerAssessCategoryRepository.GetEntities(t => t.AllotId == allot.ID);
            #region 考核方案加载上月
            var perAssSchemes = _perforPerAssessSchemeRepository.GetEntities(t => t.AllotId == prevAllotId || t.AllotId == allot.ID);
            var prevAssSchemes = perAssSchemes.Where(w => w.AllotId == prevAllotId).ToList();
            if (!prevAssSchemes.Any()) return;
            var assSchemes = perAssSchemes.Where(w => w.AllotId == allot.ID).ToList();
            if (assSchemes.Any())
            {
                assSchemes.ForEach(w => { w.AllotId = -1; w.UpdateTime = operatingTime; });
                _perforPerAssessSchemeRepository.UpdateRange(assSchemes.ToArray());
            }
            var newaSchemes = prevAssSchemes.Select(t => new per_assess_scheme
            {
                Id = 0,
                AllotId = allot.ID,
                AssessId = newperAssCategorys.Find(w => w.AssessCode == prevassCategorys.Find(s => s.Id == t.AssessId)?.AssessCode && w.AllotId == allot.ID).Id,
                SchemeCode = t.SchemeCode,
                SchemeName = t.SchemeName,
                SchemeRemarks = t.SchemeRemarks,
                CreateBy = t.CreateBy,
                CreateTime = operatingTime,
                UpdateBy = t.UpdateBy,
                UpdateTime = operatingTime,
            }).ToArray();
            _perforPerAssessSchemeRepository.AddRange(newaSchemes);
            #endregion
            //查询插入的考核方案
            var newperAssSchemes = _perforPerAssessSchemeRepository.GetEntities(t => t.AllotId == allot.ID);
            #region 考核方案指标项加载上月
            var perAssSchemeItems = _perforPerAssessSchemeItemsRepository.GetEntities(t => t.AllotId == prevAllotId || t.AllotId == allot.ID);
            var prevAssSchemeItems = perAssSchemeItems.Where(w => w.AllotId == prevAllotId).ToList();
            if (!prevAssSchemeItems.Any()) return;
            var assSchemeItems = perAssSchemeItems.Where(w => w.AllotId == allot.ID).ToList();
            if (assSchemeItems.Any())
            {
                assSchemeItems.ForEach(w => { w.AllotId = -1; w.UpdateTime = operatingTime; });
                _perforPerAssessSchemeItemsRepository.UpdateRange(assSchemeItems.ToArray());
            }
            var newaSchemeItems = prevAssSchemeItems.Select(t => new per_assess_scheme_items
            {

                Id = 0,
                AllotId = allot.ID,
                AssessId = newperAssCategorys.Find(w => w.AssessCode == prevassCategorys.Find(s => s.Id == t.AssessId)?.AssessCode && w.AllotId == allot.ID).Id,
                SchemeId = newperAssSchemes.Find(w => w.SchemeCode == prevAssSchemes.Find(s => s.Id == t.SchemeId)?.SchemeCode && w.AllotId == allot.ID).Id,
                ItemCode = t.ItemCode,
                ItemName1 = t.ItemName1,
                ItemName2 = t.ItemName2,
                UnitCode = t.UnitCode,
                UnitType = t.UnitType,
                AccountingUnit = t.AccountingUnit,
                AssessNorm = t.AssessNorm,
                AssessScore = t.AssessScore,
                CreateBy = t.CreateBy,
                CreateTime = operatingTime,
                UpdateBy = t.UpdateBy,
                UpdateTime = operatingTime,
            });
            _perforPerAssessSchemeItemsRepository.AddRange(newaSchemeItems.ToArray());
            #endregion
            //查询插入的考核方案指标项
            var newperAssSchemeItems = _perforPerAssessSchemeItemsRepository.GetEntities(t => t.AllotId == allot.ID);
            #region 被考核对象加载上月
            var perAssSchemeTargets = _perforPerAssessSchemeTargetRepository.GetEntities(t => t.AllotId == prevAllotId || t.AllotId == allot.ID);
            var prevAssSchemeTargets = perAssSchemeTargets.Where(w => w.AllotId == prevAllotId).ToList();
            if (!prevAssSchemeItems.Any()) return;
            var assSchemeTargets = perAssSchemeTargets.Where(w => w.AllotId == allot.ID).ToList();
            if (assSchemeTargets.Any())
            {
                assSchemeTargets.ForEach(w => { w.AllotId = -1; w.UpdateTime = operatingTime; });
                _perforPerAssessSchemeTargetRepository.UpdateRange(assSchemeTargets.ToArray());
            }
            var newaSchemeTarget = prevAssSchemeTargets.Select(t => new per_assess_scheme_target
            {
                Id = 0,
                AllotId = allot.ID,
                AssessId = newperAssCategorys.Find(w => w.AssessCode == prevassCategorys.Find(s => s.Id == t.AssessId)?.AssessCode && w.AllotId == allot.ID).Id,
                SchemeId = newperAssSchemes.Find(w => w.SchemeCode == prevAssSchemes.Find(s => s.Id == t.SchemeId)?.SchemeCode && w.AllotId == allot.ID).Id,
                UnitCode = t.UnitCode,
                UnitType = t.UnitType,
                AccountingUnit = t.AccountingUnit,
                CreateBy = t.CreateBy,
                CreateTime = operatingTime,
                UpdateBy = t.UpdateBy,
                UpdateTime = operatingTime,
            });
            _perforPerAssessSchemeTargetRepository.AddRange(newaSchemeTarget.ToArray());
            #endregion

            #region 考核方案下发到责任科室指标清单加载上月
            var perAssIssueSchemes = _perforPerAssessIssueSchemeRepository.GetEntities(t => t.AllotId == prevAllotId || t.AllotId == allot.ID);
            var prevAssIssueSchemes = perAssIssueSchemes.Where(w => w.AllotId == prevAllotId).ToList();
            if (!prevAssSchemeItems.Any()) return;
            var assIssueSchemes = perAssIssueSchemes.Where(w => w.AllotId == allot.ID).ToList();
            if (assIssueSchemes.Any())
            {
                assIssueSchemes.ForEach(w => { w.AllotId = -1; w.UpdateTime = operatingTime; });
                _perforPerAssessIssueSchemeRepository.UpdateRange(assIssueSchemes.ToArray());
            }
            var newaIssueSchemess = prevAssIssueSchemes.Select(t => new per_assess_issue_scheme
            {
                Id = 0,
                AllotId = allot.ID,
                AssessId = newperAssCategorys.Find(w => w.AssessCode == prevassCategorys.Find(s => s.Id == t.AssessId)?.AssessCode && w.AllotId == allot.ID).Id,
                AssessCode = t.AssessCode,
                AssessName = t.AssessName,
                SchemeId = newperAssSchemes.Find(w => w.SchemeCode == prevAssSchemes.Find(s => s.Id == t.SchemeId)?.SchemeCode && w.AllotId == allot.ID).Id,
                SchemeCode = t.SchemeCode,
                SchemeName = t.SchemeName,
                ItemId = newperAssSchemeItems.Find(w => w.ItemCode == prevAssSchemeItems.Find(s => s.Id == t.ItemId)?.ItemCode && w.AllotId == allot.ID).Id,
                ItemCode = t.ItemCode,
                ItemName1 = t.ItemName1,
                ItemName2 = t.ItemName2,
                AssessNorm = t.AssessNorm,
                AssessScore = t.AssessScore,
                UnitCode = t.UnitCode,
                UnitType = t.UnitType,
                AccountingUnit = t.AccountingUnit,
                State = (int)Assess.AssessState.未提交,
                CreateBy = t.CreateBy,
                CreateTime = operatingTime,
                UpdateBy = t.UpdateBy,
                UpdateTime = operatingTime,
                BonusPoint = null,
                BonusPointRemark = null,
                Deduction = null,
                DeductionRemark = null,
                TargetUnitCode = t.TargetUnitCode,
                TargetUnitType = t.TargetUnitType,
                TargetAccountingUnit = t.TargetAccountingUnit,
                SubmitBy = null,
                SubmitTime = null,
                AuditBy = null,
                AuditTime = null,
                AuditRemark = null,
            }).ToArray();
            _perforPerAssessIssueSchemeRepository.AddRange(newaIssueSchemess);
            #endregion
        }

    }
}
