﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class EmployeeRequest
    {
        /// <summary>
        /// 
        /// </summary>
        public int ID { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> AllotID { get; set; }

        /// <summary>
        /// sheet页id
        /// </summary>
        public Nullable<int> SheetID { get; set; }

        /// <summary>
        /// 科室类别(例如 医技科室 临床科室 其他科室)
        /// </summary>
        public string AccountType { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象
        /// </summary>
        public string FitPeople { get; set; }

        /// <summary>
        /// 医生姓名
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// 职称
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 岗位系数
        /// </summary>
        public Nullable<decimal> PostCoefficient { get; set; }

        /// <summary>
        /// 参加工作时间
        /// </summary>
        public string WorkTime { get; set; }

        /// <summary>
        /// 考核得分率
        /// </summary>
        public Nullable<decimal> ScoreAverageRate { get; set; }

        /// <summary>
        /// 出勤率
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }

        /// <summary>
        /// 核算单元医生数
        /// </summary>
        public Nullable<int> PeopleNumber { get; set; }

        /// <summary>
        /// 工作量绩效
        /// </summary>
        public Nullable<decimal> Workload { get; set; }

        /// <summary>
        /// 其他绩效
        /// </summary>
        public Nullable<decimal> OtherPerfor { get; set; }

        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> Punishment { get; set; }

        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }

        /// <summary>
        /// 发放系数
        /// </summary>
        public Nullable<decimal> Grant { get; set; }

        public class EmployeeRequestValidator : AbstractValidator<EmployeeRequest>
        {
            public EmployeeRequestValidator()
            {
                Action action = () =>
                {
                    RuleFor(x => x.AllotID).NotNull().NotEmpty();
                    RuleFor(x => x.SheetID).NotNull().NotEmpty();
                    RuleFor(x => x.AccountingUnit).NotNull().NotEmpty();
                    RuleFor(x => x.DoctorName).NotNull().NotEmpty();
                };
                RuleSet("Select", () =>
                {
                    //RuleFor(x => x.AllotID).NotNull().GreaterThan(0);
                });

                RuleSet("Insert", () =>
                {
                    RuleFor(x => x.AllotID).NotNull().NotEmpty();
                    RuleFor(x => x.AccountingUnit).NotNull().NotEmpty();
                    RuleFor(x => x.DoctorName).NotNull().NotEmpty();
                });

                RuleSet("Update", () =>
                {
                    action();
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });

                RuleSet("Delete", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });
            }
        }
    }
}
