﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class ConditionRequest
    {
        public int HospitalId { get; set; }

        public int ReportId { get; set; }

        public int[] Year { get; set; }

        public int[] Month { get; set; }

        public string[] AccountingUnit { get; set; }

        public string[] UnitType { get; set; }
    }

    public class Condition
    {
        public int Year { get; set; }

        public int Month { get; set; }

        public string AccountingUnit { get; set; }

        public string UnitType { get; set; }
    }

    public class TableData
    {
        public List<Column> Columns { get; set; }

        public JArray Data { get; set; }
    }

    public class Column
    {
        public string Label { get; set; }

        public string Prop { get; set; }

        public List<Column> Children { get; set; }
    }

    public class QueryData
    {
        public int HospitalId { get; set; }

        public int Year { get; set; }

        public int Month { get; set; }

        public string AccountingUnit { get; set; }

        public string UnitType { get; set; }

        public string SourceType { get; set; }

        public string Category { get; set; }

        public string ItemName { get; set; }

        public decimal? Value { get; set; }

        public List<QueryData> Children { get; set; }
    }

    public class QueryResult
    {
        public string Fixed1 { get; set; }

        public string Fixed2 { get; set; }

        public string Fixed3 { get; set; }

        public string Fixed4 { get; set; }

        public string Fixed5 { get; set; }

        public string Column1 { get; set; }

        public string Column2 { get; set; }

        public string Column3 { get; set; }

        public decimal? Value { get; set; }
    }
}
