﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class GuaranteeRequest
    {
        /// <summary>  </summary>
        public int Id { get; set; }

        /// <summary>  </summary>
        public int AllotId { get; set; }

        /// <summary> 优先级 </summary>
        public int Priority { get; set; }

        /// <summary> 核算单元类型 1 医生组 2 护理组 3 医技组 </summary>
        public Nullable<int> UnitType { get; set; }

        /// <summary> 保底科室 </summary>
        public string Target { get; set; }

        /// <summary> 保底来源科室 </summary>
        public List<GuaranItems> Source { get; set; }
    }


    public class GuaranteeRequestValidator : AbstractValidator<GuaranteeRequest>
    {
        public GuaranteeRequestValidator()
        {
            RuleSet("Select", () =>
            {
                RuleFor(x => x.AllotId).NotNull().NotEmpty().GreaterThan(0);
            });

            RuleSet("Insert", () =>
            {
                RuleFor(x => x.AllotId).NotNull().GreaterThan(0);
                RuleFor(x => x.Priority).NotNull().GreaterThan(0);
            });

            //RuleSet("Update", () =>
            //{
            //    RuleFor(x => x.Id).NotNull().GreaterThan(0);
            //});

            RuleSet("Delete", () =>
            {
                RuleFor(x => x.AllotId).NotNull().GreaterThan(0);
                RuleFor(x => x.Priority).NotNull().GreaterThan(0);
                RuleFor(x => x.UnitType).NotNull().GreaterThan(0);
                RuleFor(x => x.Target).NotEmpty();
            });
        }
    }
}
