﻿using Performance.EntityModels.Entity;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Performance.DtoModels
{
    public class PerAttendanceIssueDto
    {
        public PerAttendanceIssueDto()
        { }
        public PerAttendanceIssueDto(AttendanceStatistics item)
        {
            Id = 0;
            Code = item.Code;
            UnitType = item.UnitType;
            AccountingUnit = item.AccountingUnit;
            PersonnelNumber = item.PersonnelNumber;
            PersonnelName = item.PersonnelName;
            PermanentStaff = item.PermanentStaff;
            BeginDate = item.BeginDate;
            EndDate = item.EndDate;
            DeductionDays = item.Detial.Where(w => !w.Remark.Contains("不核减")).Sum(w => w.Value);
            NoDeductionDays = item.Detial.Sum(w => w.Value) - item.Detial.Where(w => !w.Remark.Contains("不核减")).Sum(w => w.Value);
            AttendanceDays = item.AttendanceDays;
            WorkFullDays = item.AttendanceDays + item.Detial.Where(w => !w.Remark.Contains("不核减")).Sum(w => w.Value);
            OperationType = (int)Attendance.OperationType.新增;
            Remarks = "";
        }

        public PerAttendanceIssueDto(per_attendance_issue item)
        {
            Id = item.Id;
            Code = item.Code;
            UnitType = item.UnitType;
            AccountingUnit = item.AccountingUnit;
            PersonnelNumber = item.PersonnelNumber;
            PersonnelName = item.PersonnelName;
            PermanentStaff = item.PermanentStaff;
            BeginDate = item.BeginDate;
            EndDate = item.EndDate;
            DeductionDays = item.DeductionDays;
            NoDeductionDays = item.NoDeductionDays;
            AttendanceDays = item.AttendanceDays;
            WorkFullDays = item.WorkFullDays;
            OperationType = (int)Attendance.OperationType.删除;
            Remarks = "删除数据";
        }

        //public int HospitalId { get; set; } //医院Id
        //public int AllotId { get; set; } //绩效Id
        public int Id { get; set; }
        public string Code { get; set; } //核算单元编码
        /// <summary>
        /// 人员类别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 工号
        /// </summary>
        public string PersonnelNumber { get; set; }
        /// <summary>
        /// 姓名
        /// </summary>
        public string PersonnelName { get; set; }
        /// <summary>
        /// 人员系数
        /// </summary>
        public decimal? PermanentStaff { get; set; }
        /// <summary>
        /// 在科开始时间
        /// </summary>
        public DateTime? BeginDate { get; set; }
        /// <summary>
        /// 在科结束时间
        /// </summary>
        public DateTime? EndDate { get; set; }
        /// <summary>
        /// 全勤天数
        /// </summary>
        public int WorkFullDays { get; set; }
        /// <summary>
        /// 出勤天数
        /// </summary>
        public int AttendanceDays { get; set; }
        /// <summary>
        /// 核减天数
        /// </summary>
        public int DeductionDays { get; set; }
        /// <summary>
        /// 不核减天数
        /// </summary>
        public int NoDeductionDays { get; set; }
        /// <summary>
        /// 操作类型 新增 = 1, 修改 = 2, 删除 = 3,
        /// </summary>
        public int OperationType { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remarks { get; set; }
    }
}
