﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class MessageInfo : MessageInfo<string>
    {
        public MessageInfo()
            : this(default, string.Empty, string.Empty)
        {
        }

        public MessageInfo(int allotId, string title, string message)
            : this(allotId, title, message, Component.Notification, ComponentType.info)
        {
        }

        public MessageInfo(int allotId, string title, string message, ComponentType type)
            : this(allotId, title, message, Component.Notification, type)
        {
        }

        public MessageInfo(int allotId, string title, string message, Component component)
            : this(allotId, title, message, component, ComponentType.info)
        {
        }

        public MessageInfo(int allotId, string title, string message, Component component, ComponentType type)
            : this(Guid.NewGuid().ToString("N"), allotId, title, message, component, type)
        {
        }

        public MessageInfo(string uuid, int allotId, string title, string message, Component component, ComponentType type)
        {
            Uuid = uuid;
            AllotId = allotId;
            Title = title;
            Message = message;
            Component = component;
            Status = type;
        }
    }

    public class MessageInfo<TData> : IMessageInfo<TData>
    {
        public string Uuid { get; set; }

        public int AllotId { get; set; }

        public string Title { get; set; }

        public TData Message { get; set; }

        public Component Component { get; set; }

        [JsonIgnore]
        public ComponentType Status { get; set; }

        public string Type
        {
            get
            {
                return Status.ToString();
            }
        }

        public MessageInfo()
            : this(default, string.Empty, default)
        {
        }

        public MessageInfo(int allotId, string title, TData message)
            : this(allotId, title, message, Component.Notification, ComponentType.info)
        {
        }

        public MessageInfo(int allotId, string title, TData message, ComponentType type)
            : this(allotId, title, message, Component.Notification, type)
        {
        }

        public MessageInfo(int allotId, string title, TData message, Component component)
            : this(allotId, title, message, component, ComponentType.info)
        {
        }

        public MessageInfo(int allotId, string title, TData message, Component component, ComponentType type)
            : this(Guid.NewGuid().ToString("N"), allotId, title, message, component, type)
        {
        }

        public MessageInfo(string uuid, int allotId, string title, TData message, Component component, ComponentType type)
        {
            Uuid = uuid;
            AllotId = allotId;
            Title = title;
            Message = message;
            Component = component;
            Status = type;
        }
    }

    public interface IMessageInfo<TData>
    {
        /// <summary>
        /// 唯一编码
        /// </summary>
        string Uuid { get; set; }

        /// <summary>
        /// 绩效Id
        /// </summary>
        int AllotId { get; set; }

        /// <summary>
        /// 标题
        /// </summary>
        string Title { get; set; }

        /// <summary>
        /// 内容
        /// </summary>
        TData Message { get; set; }

        /// <summary>
        /// 控件类型
        /// </summary>
        Component Component { get; set; }

        /// <summary>
        /// 状态（完成、警告、错误、信息）
        /// </summary>
        ComponentType Status { get; set; }

        /// <summary>
        /// 状态文本值
        /// </summary>
        string Type { get; }
    }
}
