﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class BudgetResponse : BudgetDto
    {
        public int Id { get; set; }

        public int HospitalId { get; set; }

        public int Year { get; set; }

        /// <summary>
        /// 数据来源 1. 金额 2. 占比
        /// </summary>
        public int Type { get; set; }
    }

    public class BudgetDto
    {
        /// <summary>
        /// 医院业务收入(万)
        /// </summary>
        public Nullable<decimal> HospitalRevenue { get; set; }

        /// <summary>
        /// 人力总成本（万）
        /// </summary>
        public Nullable<decimal> TotalLaborCost { get; set; }

        /// <summary>
        /// 人员支出固定部分（万）
        /// </summary>
        public Nullable<decimal> StaffSpendingFixed { get; set; }

        /// <summary>
        /// 人员支出浮动部分（奖金）
        /// </summary>
        public Nullable<decimal> StaffSpendingBonus { get; set; }

        /// <summary>
        /// 绩效工资增量预算比例
        /// </summary>
        public Nullable<decimal> MeritPayIncrement { get; set; }

        /// <summary>
        /// 绩效工资合计
        /// </summary>
        public Nullable<decimal> TotalMeritPay { get; set; }

        /// <summary>
        /// 人员数
        /// </summary>
        public Nullable<decimal> AmountOfStaff { get; set; }

        /// <summary>
        /// 原人均月绩效（元）
        /// </summary>
        public Nullable<decimal> ThePerCapitaMerit { get; set; }

        /// <summary>
        /// 增量后人均绩效（元）
        /// </summary>
        public Nullable<decimal> TheIncrementCapita { get; set; }

        /// <summary>
        /// 增长幅度
        /// </summary>
        public Nullable<decimal> Amplification { get; set; }

        /// <summary>
        /// 增量后绩效工资人员经费比例
        /// </summary>
        public Nullable<decimal> IncrementCapitaRatio { get; set; }

        /// <summary>
        /// 药品收入（万）
        /// </summary>
        public Nullable<decimal> TheDrugIncome { get; set; }

        /// <summary>
        /// 药品收入预算比例
        /// </summary>
        public Nullable<decimal> TheDrugIncomeBudget { get; set; }

        /// <summary>
        /// 材料支出（万）
        /// </summary>
        public Nullable<decimal> MaterialIncome { get; set; }

        /// <summary>
        /// 材料支出预算比例
        /// </summary>
        public Nullable<decimal> MaterialIncomeBudget { get; set; }

        /// <summary>
        /// 药品+材料+人支（万）
        /// </summary>
        public Nullable<decimal> TheCostInTotal { get; set; }

        /// <summary>
        /// 固定资产折旧费（万）
        /// </summary>
        public Nullable<decimal> DepreOfFixedAssets { get; set; }

        /// <summary>
        /// 无形资产摊销费（万）
        /// </summary>
        public Nullable<decimal> AmortOfIntangibleAssets { get; set; }

        /// <summary>
        /// 提取医疗风险基金（万）
        /// </summary>
        public Nullable<decimal> MedicalRisk { get; set; }

        /// <summary>
        /// 其他费用（万）
        /// </summary>
        public Nullable<decimal> OtherExpenses { get; set; }

        /// <summary>
        /// 收支结余（%）
        /// </summary>
        public Nullable<decimal> BalanceOfPayments { get; set; }

        /// <summary>
        /// 财政补贴
        /// </summary>
        public Nullable<decimal> FiscalSubsidies { get; set; }

        /// <summary>
        /// 医院总收支结余
        /// </summary>
        public Nullable<decimal> TheTotalHospitalBalance { get; set; }
    }
}
