﻿using Performance.DtoModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{

    public class RecognitionDataFormat
    {
        /*
            0 General General 18 Time h:mm AM/PM
            1 Decimal 0 19 Time h:mm:ss AM/PM
            2 Decimal 0.00 20 Time h:mm
            3 Decimal #,##0 21 Time h:mm:ss
            4 Decimal #,##0.00 2232 Date/Time M/D/YY h:mm
            5 Currency "$"#,##0_);("$"#,##0) 37 Account. _(#,##0_);(#,##0)
            6 Currency "$"#,##0_);[Red]("$"#,##0) 38 Account. _(#,##0_);[Red](#,##0)
            7 Currency "$"#,##0.00_);("$"#,##0.00) 39 Account. _(#,##0.00_);(#,##0.00)
            8 Currency "$"#,##0.00_);[Red]("$"#,##0.00) 40 Account. _(#,##0.00_);[Red](#,##0.00)
            9 Percent 0% 4131 Currency _("$"* #,##0_);_("$"* (#,##0);_("$"* "-"_);_(@_)
            10 Percent 0.00% 4231 33 Currency _(* #,##0_);_(* (#,##0);_(* "-"_);_(@_)
            11 Scientific 0.00E+00 4331 Currency _("$"* #,##0.00_);_("$"* (#,##0.00);_("$"* "-"??_);_(@_)
            12 Fraction # ?/? 4431 33 Currency _(* #,##0.00_);_(* (#,##0.00);_(* "-"??_);_(@_)
            13 Fraction # ??/?? 45 Time mm:ss
            14 Date M/D/YY 46 Time [h]:mm:ss
            15 Date D-MMM-YY 47 Time mm:ss.0
            16 Date D-MMM 48 Scientific ##0.0E+0
            17 Date MMM-YY 49 Text @
         */
        private static Dictionary<DataFormat, int[]> dic = new Dictionary<DataFormat, int[]>
        {
            { DataFormat.普通格式, new[] { 0 } },
            { DataFormat.小数, new[] { 1,2,3,4 } },
            { DataFormat.货币, new[] { 5,6,7,8 } },
            { DataFormat.百分比, new[] { 9,10 } },
            { DataFormat.科学计数, new[] { 11 } },
            { DataFormat.分数, new[] { 12,13 } },
            { DataFormat.日期, new[] { 14,15,16,17 } },
        };

        public static DataFormat GetDataFormat(short type)
        {
            foreach (var item in dic.Keys)
            {
                if (dic[item].Contains(type))
                    return item;
            }
            return DataFormat.普通格式;
        }
    }
}
