﻿using AutoMapper;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class RoleService : IAutoInjection
    {
        private PerforRoleRepository _roleRepository;
        private PerforUserroleRepository _userroleRepository;
        private PerforUserRepository _userRepository;

        public RoleService(PerforRoleRepository roleRepository,
            PerforUserroleRepository userroleRepository,
            PerforUserRepository userRepository)
        {
            this._roleRepository = roleRepository;
            this._userroleRepository = userroleRepository;
            _userRepository = userRepository;
        }

        /// <summary>
        /// 获取用户角色
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public List<RoleResponse> GetUserRole(int userid)
        { 
            var roles = GetRole(userid);
            return Mapper.Map<List<RoleResponse>>(roles);
        }


        /// <summary>
        /// 获取用户角色
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public List<sys_role> GetRole(int userid)
        {
            if (userid <= 0)
                throw new PerformanceException($"userid：{userid} 错误");

            var joinList = _userroleRepository.GetEntities(t => t.UserID == userid);
            if (joinList == null && joinList.Count == 0)
                return null;

            var roles = _roleRepository.GetEntities(t => joinList.Select(j => j.RoleID).Contains(t.ID));

            return roles;
        }

        public List<RoleResponse> GetUsersRole(int userid)
        {
            List<RoleResponse> roleResponses = new List<RoleResponse>();
            var user=_userRepository.GetEntity(c => c.ID == userid);
            var ParentUser = _userRepository.GetEntities(c => c.ParentID == userid);
            if (user.ParentID!=null || user.ParentID==0)
            {
                ParentUser=_userRepository.GetEntities(c => c.ParentID == user.ParentID);
            }
            
            if (ParentUser != null)   
            {
                foreach (var sysUser in ParentUser)
                {
                    var useRoles = GetARole(sysUser.ID);
                    var role = Mapper.Map<RoleResponse>(useRoles);
                    role.Value = sysUser.ID;
                    roleResponses.Add(role);
                }
            }
            var roles = GetARole(userid);
            if (roles!=null)
            {
                var role = Mapper.Map<RoleResponse>(roles);
                role.Value = userid;
                roleResponses.Add(role);
            }
            return roleResponses;
        }

        /// <summary>
        /// 获取用户角色
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public sys_role GetARole(int userid)
        {
            if (userid <= 0)
                throw new PerformanceException($"userid：{userid} 错误");

            var joinList = _userroleRepository.GetEntities(t => t.UserID == userid);
            if (joinList == null)
                return null;

            var roles = _roleRepository.GetEntity(t => joinList.Select(j => j.RoleID).Contains(t.ID));

            return roles;
        }
    }
}
