﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class ComputeEmployee
    {
        /// <summary>
        /// 科室类别(例如 医技科室 临床科室 其他科室)
        /// </summary>
        public string AccountType { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象
        /// </summary>
        public string FitPeople { get; set; }

        /// <summary>
        /// 绩效基础核算参考值
        /// </summary>
        public Nullable<decimal> FitPeopleValue { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象取值比例（如临床科室护士*95%）
        /// </summary>
        public Nullable<decimal> FitPeopleRatio { get; set; }

        /// <summary>
        /// 核算基数
        /// </summary>
        public Nullable<decimal> BasicNorm { get; set; }

        /// <summary>
        /// 其他管理绩效
        /// </summary>
        public Nullable<decimal> OtherManagePerfor { get; set; }

        /// <summary>
        /// 医生姓名
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// 职称
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 工号
        /// </summary>
        public string JobNumber { get; set; }

        /// <summary>
        /// 基础绩效系数
        /// </summary>
        public Nullable<decimal> Basics { get; set; }

        /// <summary>
        /// 岗位系数
        /// </summary>
        public Nullable<decimal> PostCoefficient { get; set; }

        /// <summary>
        /// 效率绩效人数
        /// </summary>
        public Nullable<decimal> PermanentStaff { get; set; }

        ///// <summary>
        ///// 参加工作时间
        ///// </summary>
        //public Nullable<DateTime> WorkTime { get; set; }

        /// <summary>
        /// 考核前其他绩效
        /// </summary>
        public Nullable<decimal> AssessBeforeOtherFee { get; set; }

        /// <summary>
        /// 考核得分率
        /// </summary>
        public Nullable<decimal> ScoreAverageRate { get; set; }

        /// <summary>
        /// 考核后其他绩效
        /// </summary>
        public Nullable<decimal> AssessLaterOtherFee { get; set; }

        /// <summary>
        /// 调节后其他绩效
        /// </summary>
        public Nullable<decimal> AdjustLaterOtherFee { get; set; }

        /// <summary>
        /// 出勤率
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }

        ///// <summary>
        ///// 核算单元医生数
        ///// </summary>
        //public Nullable<int> PeopleNumber { get; set; }

        ///// <summary>
        ///// 工作量绩效
        ///// </summary>
        //public Nullable<decimal> Workload { get; set; }

        /// <summary>
        /// 其他绩效
        /// </summary>
        public Nullable<decimal> OtherPerfor { get; set; }

        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> Punishment { get; set; }

        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }

        ///// <summary>
        ///// 发放系数
        ///// </summary>
        //public Nullable<decimal> Grant { get; set; }

        /// <summary>
        /// 核算单元分类
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 效率绩效系数
        /// </summary>
        public Nullable<decimal> Efficiency { get; set; }

        /// <summary>
        /// 规模绩效系数
        /// </summary>
        public Nullable<decimal> Scale { get; set; }

        /// <summary>
        /// 管理绩效发放系数
        /// </summary>
        public Nullable<decimal> Management { get; set; }

        /// <summary>
        /// 夜班费
        /// </summary>
        public Nullable<decimal> NightWorkPerfor { get; set; }
    }
}
