﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class ComputerRequest
    {
        /// <summary>
        /// 绩效数据id
        /// </summary>
        public int ComputeId { get; set; }

        /// <summary>
        /// 实发绩效
        /// </summary>
        public decimal? RealGiveFee { get; set; }

        /// <summary>
        /// 绩效id
        /// </summary>
        public int AllotId { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象
        /// </summary>
        public int Type { get; set; }

    }
    public class ComputerRequestValidator : AbstractValidator<ComputerRequest>
    {
        public ComputerRequestValidator()
        {
            RuleFor(x => x.AllotId).NotNull().GreaterThan(0);
            RuleSet("Select", () =>
            {
                RuleFor(x => x.Type).NotNull().NotEmpty();
            });

            RuleSet("UpdateReal", () =>
            {
                RuleFor(x => x.ComputeId).NotNull().GreaterThan(0);
                RuleFor(x => x.RealGiveFee).NotNull();
            });
        }
    }
}
