//-----------------------------------------------------------------------
// <copyright file=" sys_hospital.cs">
// * FileName: 医院信息.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 医院信息
    /// </summary>
    [Table("sys_hospital")]
    public class sys_hospital
    {
        /// <summary>
        /// ID
        /// </summary>
        [Key]
        public int ID { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<DateTime> CreateDate { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> CreateUser { get; set; }

        /// <summary>
        /// 医院名称
        /// </summary>
        public string HosName { get; set; }

        /// <summary>
        /// 简称
        /// </summary>
        public string ShortName { get; set; }

        /// <summary>
        /// 医院区域编码
        /// </summary>
        public string AreaCode { get; set; }

        /// <summary>
        /// 医院等级
        /// </summary>
        public string HosLevel { get; set; }

        /// <summary>
        /// 医院类型
        /// </summary>
        public string HosType { get; set; }

        /// <summary>
        /// 医院状态 1 启用 2 禁用
        /// </summary>
        public Nullable<int> States { get; set; }

        /// <summary>
        /// 是否开启年资系数 1 启用 2 禁用
        /// </summary>
        public Nullable<int> IsOpenWorkYear { get; set; }

        /// <summary>
        /// 是否开启药占比系数 1 启用 2 禁用
        /// </summary>
        public Nullable<int> IsOpenDrugprop { get; set; }

        /// <summary>
        /// 是否开启ICU有效收入系数 1 启用 2 禁用
        /// </summary>
        public Nullable<int> IsOpenIncome { get; set; }

        /// <summary>
        /// 是否开启规模/效率绩效 1 启用 2 禁用
        /// </summary>
        public Nullable<int> IsOpenDirector { get; set; }

        /// <summary>
        /// 是否显示绩效合计 1 显示绩效合计 2 显示管理绩效
        /// </summary>
        public Nullable<int> IsShowManage { get; set; }

        /// <summary>
        /// 是否开启科室CMI占比 1 启用 2 禁用
        /// </summary>
        public Nullable<int> IsOpenCMIPercent { get; set; }

        /// <summary>
        /// 是否开启护理部审核 1 启用 2 禁用
        /// </summary>
        public Nullable<int> IsOpenNursingDeptAudit { get; set; }

        /// <summary>
        /// 是否显示二次绩效科主任1 启用 2 禁用
        /// </summary>
        public Nullable<int> IsShowSecondDirector { get; set; }

        /// <summary>
        /// 是否开启行政后勤二次绩效分配 1 启用 2 禁用
        /// </summary>
        public Nullable<int> IsOpenLogisticsSecondAllot { get; set; }

        /// <summary>
        /// 抽取项目是否在同一环境 1 是 2 否
        /// </summary>
        public Nullable<int> IsSingleProject { get; set; }
    }
}
