﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.DtoModels
{
    public class SetAssessRequest
    {
        public int AllotID { get; set; }
        public int AssessID { get; set; }
        public List<string> Department { get; set; }
    }

    public class SetAssessRequestValidator : AbstractValidator<SetAssessRequest>
    {
        public SetAssessRequestValidator()
        {
            RuleFor(t => t.AllotID).NotNull().GreaterThan(0);
            RuleFor(t => t.AssessID).NotNull().GreaterThan(0);
            RuleFor(t => t.Department).NotNull().Must(p =>
            {
                return p != null && p.Count > 0 && !p.Any(t => t.Trim() == "");
            });
        }
    }
}
