﻿using Microsoft.Extensions.Logging;
using Performance.EntityModels;
using Performance.Repository;
using Performance.Repository.Repository;
using System;
using System.Linq;

namespace Performance.Services
{
    public class CopyService : IAutoInjection
    {
        private readonly ILogger<ConfigService> _logger;
        private readonly PerforPerdeptdicRepository _perdeptdicRepository;
        private readonly PerforCofworkitemRepository _workitemRepository;
        private readonly PerforCofagainRepository _againRepository;
        private readonly PerforCofdrugtypeRepository _drugtypeRepository;
        private readonly PerforCofdepttypeRepository _perforCofdepttypeRepository;
        private readonly PerforCofaccountingRepository _cofaccountingRepository;
        private readonly PerforCofdrugtypeDisburseRepository _drugtypeDisburseRepository;
        private readonly PerforCofdrugtypefactorRepository _cofdrugtypefactorRepository;

        public CopyService(
            ILogger<ConfigService> logger,
            PerforPerdeptdicRepository perdeptdicRepository,
            PerforCofagainRepository againRepository,
            PerforCofdrugtypeRepository drugtypeRepository,
            PerforCofworkitemRepository workitemRepository,
            PerforCofdepttypeRepository perforCofdepttypeRepository,
            PerforCofaccountingRepository cofaccountingRepository,
            PerforCofdrugtypeDisburseRepository drugtypeDisburseRepository,
            PerforCofdrugtypefactorRepository cofdrugtypefactorRepository)
        {
            _logger = logger;
            _perdeptdicRepository = perdeptdicRepository;
            _workitemRepository = workitemRepository;
            _againRepository = againRepository;
            _drugtypeRepository = drugtypeRepository;
            _perforCofdepttypeRepository = perforCofdepttypeRepository;
            _cofaccountingRepository = cofaccountingRepository;
            _drugtypeDisburseRepository = drugtypeDisburseRepository;
            _cofdrugtypefactorRepository = cofdrugtypefactorRepository;
        }


        public void Copy_WorkItems(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy workItems");
            var workItems = _workitemRepository.GetEntities(t => t.AllotID == allot.ID);
            if (delHistotyData && workItems != null && workItems.Any())
                flag = _workitemRepository.RemoveRange(workItems.ToArray());
            if (flag || workItems == null || !workItems.Any())
            {
                workItems = _workitemRepository.GetEntities(t => t.AllotID == prevAllotId) ?? _workitemRepository.GetEntities(t => t.AllotID == -1);
                if (workItems != null && workItems.Any())
                {
                    var newWorkItems = workItems.Select(t => new cof_workitem { AllotID = allot.ID, Type = t.Type, Item = t.Item });
                    _workitemRepository.AddRange(newWorkItems.ToArray());
                }
            }
        }


        public void Copy_DrugTypes(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy drugTypes");
            var drugTypes = _drugtypeRepository.GetEntities(t => t.AllotID == allot.ID && t.HospitalId == allot.HospitalId);
            if (delHistotyData && drugTypes != null && drugTypes.Any())
                flag = _drugtypeRepository.RemoveRange(drugTypes.ToArray());
            if (flag || drugTypes == null || !drugTypes.Any())
            {
                drugTypes = _drugtypeRepository.GetEntities(t => t.AllotID == prevAllotId && t.HospitalId == allot.HospitalId) ?? _drugtypeRepository.GetEntities(t => t.AllotID == -1);
                if (drugTypes != null && drugTypes.Any())
                {
                    var newDrugTypes = drugTypes.Select(t => new cof_drugtype { HospitalId = allot.HospitalId, AllotID = allot.ID, Charge = t.Charge, ChargeType = t.ChargeType });
                    _drugtypeRepository.AddRange(newDrugTypes.ToArray());
                }
            }
        }


        public void Copy_DrugTypeDisburses(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy drugTypeDisburses");
            var drugTypeDisburses = _drugtypeDisburseRepository.GetEntities(t => t.AllotID == allot.ID && t.HospitalId == allot.HospitalId);
            if (delHistotyData && drugTypeDisburses != null && drugTypeDisburses.Any())
                flag = _drugtypeDisburseRepository.RemoveRange(drugTypeDisburses.ToArray());
            if (flag || drugTypeDisburses == null || !drugTypeDisburses.Any())
            {
                drugTypeDisburses = _drugtypeDisburseRepository.GetEntities(t => t.AllotID == prevAllotId && t.HospitalId == allot.HospitalId)
                    ?? _drugtypeDisburseRepository.GetEntities(t => t.AllotID == -1);
                if (drugTypeDisburses != null && drugTypeDisburses.Any())
                {
                    var newDrugTypeDisburses = drugTypeDisburses.Select(t => new cof_drugtype_disburse { HospitalId = allot.HospitalId, AllotID = allot.ID, Charge = t.Charge, ChargeType = t.ChargeType });
                    _drugtypeDisburseRepository.AddRange(newDrugTypeDisburses.ToArray());
                }
            }
        }


        public void Copy_DrugTypeFactors(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy drugTypeFactors");
            var drugTypeFactors = _cofdrugtypefactorRepository.GetEntities(t => t.AllotID == allot.ID && t.HospitalId == allot.HospitalId);
            if (delHistotyData && drugTypeFactors != null && drugTypeFactors.Any())
                flag = _cofdrugtypefactorRepository.RemoveRange(drugTypeFactors.ToArray());
            if (flag || drugTypeFactors == null || !drugTypeFactors.Any())
            {
                drugTypeFactors = _cofdrugtypefactorRepository.GetEntities(t => t.AllotID == prevAllotId && t.HospitalId == allot.HospitalId)
                    ?? _cofdrugtypefactorRepository.GetEntities(t => t.AllotID == -1);
                if (drugTypeFactors != null && drugTypeFactors.Any())
                {
                    var newDrugtypeFactors = drugTypeFactors.Select(t => new cof_drugtype_factor
                    {
                        HospitalId = allot.HospitalId,
                        AllotID = allot.ID,
                        ExModuleId = t.ExModuleId,
                        Charge = t.Charge,
                        YSZ = t.YSZ,
                        HLZ = t.HLZ,
                        YJZ = t.YJZ
                    });
                    _cofdrugtypefactorRepository.AddRange(newDrugtypeFactors.ToArray());
                }
            }
        }


        public void Copy_DeptTypes(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy deptTypes");
            var deptTypes = _perforCofdepttypeRepository.GetEntities(t => t.AllotID == allot.ID);
            if (delHistotyData && deptTypes != null && deptTypes.Any())
                flag = _perforCofdepttypeRepository.RemoveRange(deptTypes.ToArray());
            if (flag || deptTypes == null || !deptTypes.Any())
            {
                deptTypes = _perforCofdepttypeRepository.GetEntities(t => t.AllotID == prevAllotId) ?? _perforCofdepttypeRepository.GetEntities(t => t.AllotID == -1);
                if (deptTypes != null && deptTypes.Any())
                {
                    var newDeptTypes = deptTypes.Select(t => new cof_depttype { AllotID = allot.ID, Charge = t.Charge, ChargeType = t.ChargeType });
                    _perforCofdepttypeRepository.AddRange(newDeptTypes.ToArray());
                }
            }
        }


        public void Copy_Agains(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy agains");
            var agains = _againRepository.GetEntities(t => t.AllotID == allot.ID);
            if (delHistotyData && agains != null && agains.Any())
                flag = _againRepository.RemoveRange(agains.ToArray());
            if (flag || agains == null || !agains.Any())
            {
                agains = _againRepository.GetEntities(t => t.AllotID == prevAllotId) ?? _againRepository.GetEntities(t => t.AllotID == -1);
                if (agains != null && agains.Any())
                {
                    var days = DateTime.DaysInMonth(allot.Year, allot.Month);
                    var newAgains = agains.Select(t => new cof_again
                    {
                        AllotID = allot.ID,
                        Type = t.Type,
                        Department = t.Department,
                        TypeName = t.TypeName,
                        Value = t.TypeName == "满勤天数" ? days : t.Value
                    });
                    _againRepository.AddRange(newAgains.ToArray());
                }
            }
        }


        public void Copy_Accountings(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy accountings");
            var accountings = _cofaccountingRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && accountings != null && accountings.Any())
                flag = _cofaccountingRepository.RemoveRange(accountings.ToArray());
            if (flag || accountings == null || !accountings.Any())
            {
                accountings = _cofaccountingRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _cofaccountingRepository.GetEntities(t => t.AllotId == -1);
                if (accountings != null && accountings.Any())
                {
                    var newAccountings = accountings.Select(t => new cof_accounting
                    {
                        AllotId = allot.ID,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        Code = t.Code,
                        IsVerify = t.IsVerify,
                        VerifyMessage = t.VerifyMessage
                    });
                    _cofaccountingRepository.AddRange(newAccountings.ToArray());
                }
            }
        }


        public void Copy_DeptDic(per_allot allot, int prevAllotId, bool delHistotyData = false)
        {
            var flag = delHistotyData;
            _logger.LogInformation($"copy per_dept_dic");
            var deptDic = _perdeptdicRepository.GetEntities(t => t.AllotId == allot.ID);
            if (delHistotyData && deptDic != null && deptDic.Any())
                flag = _perdeptdicRepository.RemoveRange(deptDic.ToArray());
            if (flag || deptDic == null || !deptDic.Any())
            {
                deptDic = _perdeptdicRepository.GetEntities(t => t.AllotId == prevAllotId) ?? _perdeptdicRepository.GetEntities(t => t.AllotId == -1);
                if (deptDic != null && deptDic.Any())
                {
                    var newDeptDic = deptDic.Select(t => new per_dept_dic
                    {
                        AllotId = allot.ID,
                        UnitType = t.UnitType,
                        AccountingUnit = t.AccountingUnit,
                        CreateTime = t.CreateTime,
                        CreateUser = t.CreateUser,
                        Department = t.Department,
                        HISDeptName = t.HISDeptName,
                        HospitalId = t.HospitalId,
                        Source = t.Source,
                        IsVerify = t.IsVerify,
                        VerifyMessage = t.VerifyMessage
                    });
                    _perdeptdicRepository.AddRange(newDeptDic.ToArray());
                }
            }
        }

    }
}
