﻿using FluentScheduler;
using Microsoft.Extensions.Logging;
using Performance.DtoModels;
using Performance.Infrastructure;
using Performance.Repository;
using Performance.Services;
using System;
using System.Linq;

namespace Performance.Api
{
    public class AutoSyncConfigJob : IJob
    {
        private readonly ILogger logger;
        private readonly PerforPerallotRepository perallotRepository;
        private readonly ConfigService configService;

        public AutoSyncConfigJob(
            ILogger<AutoSyncConfigJob> logger,
            PerforPerallotRepository perallotRepository,
            ConfigService configService
            )
        {
            this.logger = logger;
            this.perallotRepository = perallotRepository;
            this.configService = configService;
        }

        public void Execute()
        {
            try
            {
                logger.LogInformation("开始同步配置");
                //先查询perallot所有数据
                var list = perallotRepository.GetEntities();
                if (list == null || !list.Any()) return;

                var hospitalIds = list.Select(t => t.HospitalId).Distinct().OrderBy(t => t);
                //按照医院循环
                foreach (var hospitalId in hospitalIds)
                {
                    //按年月进行倒序查询allots
                    var allots = list.Where(w => w.HospitalId == hospitalId && string.IsNullOrEmpty(w.Path) && w.IsModifyConfig != 1)?.OrderByDescending(t => t.Year).ThenByDescending(t => t.Month).ToList();
                    if (allots == null || !allots.Any()) continue;

                    foreach (var item in allots)
                    {
                        configService.NewCopy(new CopyRequest() { AllotId = item.ID, Type = new[] { "personnels", "workItems", "drugTypeDisburses", "drugTypeFactors", "deptTypes", "agains", "accountings", "department" } });
                    }
                    #region 旧代码

                    ////如果allots不为null 并且 数据存在没修改过的，进行循环
                    //while (allots != null && allots.Any(w => w.IsModifyConfig == 0) && allots.Any(w => w.IsModifyConfig == 1))
                    //{
                    //    //查询最近一次修改过的allot
                    //    var prevAllot = allots.FirstOrDefault(t => t.IsModifyConfig == 1);
                    //    //if (prevAllot == null) continue;

                    //    //获取最近一次修改过的月份
                    //    var date = ConvertHelper.To<DateTime>($"{prevAllot.Year}-{prevAllot.Month}");
                    //    //查找需要同步的allot(条件为 最近一次修改过的月份之后的所有allot)
                    //    var needSyncData = allots.Where(w => ConvertHelper.To<DateTime>($"{w.Year}-{w.Month}") > date);
                    //    if (needSyncData != null && needSyncData.Any())
                    //    {
                    //        //开始同步查询到的allot
                    //        foreach (var item in needSyncData)
                    //            configService.NewCopy(new CopyRequest() { AllotId = item.ID, Type = new[] { "personnels", "workItems", "drugTypeDisburses", "drugTypeFactors", "deptTypes", "agains", "accountings", "department" } });
                    //    }
                    //    //同步完之后查询 最近一次修改过的allot 之前的第一条未修改的allot
                    //    var noModify = allots.FirstOrDefault(w => ConvertHelper.To<DateTime>($"{w.Year}-{w.Month}") < date && w.IsModifyConfig == 0);
                    //    if (noModify != null)
                    //        //最近一次修改过的月份 更改为 前的第一条数据的月份
                    //        date = ConvertHelper.To<DateTime>($"{noModify.Year}-{noModify.Month}");

                    //    //当次循环allots只保留 小于 最近一次修改过的月份
                    //    allots = allots.Where(w => ConvertHelper.To<DateTime>($"{w.Year}-{w.Month}") <= date)?.ToList();
                    //}
                    #endregion
                }
                logger.LogInformation("同步配置结束");
            }
            catch (Exception ex)
            {
                logger.LogError($"同步配置发生异常：" + ex);
            }

        }
    }
}
