﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.DtoModels
{
    public class PerHeader
    {
        /// <summary>
        /// 唯一标准
        /// </summary>
        public string SignID { get; set; }
        public int PointRow { get; set; }
        public int PointCell { get; set; }
        public bool IsMerge => MergeRow > 1 || MergeCell > 1;
        public int MergeRow { get; set; }
        public int MergeCell { get; set; }
        public string CellValue { get; set; }
        /// <summary>
        /// 1 汇总  2原始数据
        /// </summary>
        public int IsTotal { get; set; }

        public int Level { get; set; }
        public bool IsHasChildren => Children != null && Children.Any();
        public List<PerHeader> Children { get; set; }
        public PerHeader Parent { get; set; }

        public PerHeader() { }

        public PerHeader(int pointRow, int pointCell, string cellName, int level, int mergeRow, int mergeCell, List<PerHeader> children, int isTotal)
        {
            PointRow = pointRow;
            PointCell = pointCell;
            CellValue = cellName;
            Level = level;
            MergeRow = mergeRow;
            MergeCell = mergeCell;
            Children = children;
            SignID = Guid.NewGuid().ToString("N");
            IsTotal = isTotal;
        }
    }
}
