﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Options;
using Performance.DtoModels.AppSettings;
using Performance.EntityModels;

namespace Performance.Api.Configurations
{
    public static class DatabaseConfig
    {
        public static void AddDatabaseConfiguration(this IServiceCollection services)
        {
            if (services == null) throw new ArgumentNullException(nameof(services));

            var connection = services.BuildServiceProvider().GetService<IOptions<AppConnection>>();

            services.AddDbContext<PerformanceDbContext>(options =>
            {
                var connectionString = connection.Value.PerformanceConnectionString;
                var serverVersion = ServerVersion.AutoDetect(connection.Value.PerformanceConnectionString);
                var builder = options.UseMySql(connectionString, serverVersion, optionBuilder =>
                {
                    optionBuilder.EnableStringComparisonTranslations(true);
                    optionBuilder.EnableRetryOnFailure();
                });
                builder.EnableSensitiveDataLogging().EnableDetailedErrors();
            }, ServiceLifetime.Transient);
        }
    }
}
