﻿using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.Services;

namespace Performance.Api.Controllers
{
    /// <summary>
    /// 原始数据修改
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    public class OriginalController : Controller
    {
        private readonly ClaimService claim;
        private readonly OriginalService originalService;
        private readonly AllotService allotService;

        public OriginalController(ClaimService claim,
            OriginalService originalService,
            AllotService allotService)
        {
            this.claim = claim;
            this.originalService = originalService;
            this.allotService = allotService;
        }

        /// <summary>
        /// 修改factor数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("factor")]
        [HttpPost]
        public ApiResponse FactorEdit([FromBody] OriginalRequest request)
        {
            if (request.Cell.Id <= 0)
                return new ApiResponse(ResponseType.Fail, "当前列费用无效，无法修改");

            var result = originalService.EditFactorData(claim.GetUserId(), request);
            return result ? new ApiResponse(ResponseType.OK, "修改成功") : new ApiResponse(ResponseType.Fail, "修改失败");
        }

        /// <summary>
        /// 修改header数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("header")]
        [HttpPost]
        public ApiResponse HeaderEdit([FromBody] OriginalRequest request)
        {
            var result = originalService.EditHeaderData(claim.GetUserId(), request);
            return result ? new ApiResponse(ResponseType.OK, "修改成功") : new ApiResponse(ResponseType.Fail, "修改失败");
        }

        /// <summary>
        /// 修改sheet数据
        /// </summary>
        /// <returns></returns>
        [Route("sheet")]
        [HttpPost]
        public ApiResponse SheetEdit([FromBody] OriginalRequest request)
        {
            var result = originalService.EditSheetData(claim.GetUserId(), request);
            return result ? new ApiResponse(ResponseType.OK, "修改成功") : new ApiResponse(ResponseType.Fail, "修改失败");
        }
    }
}
