﻿using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.Services;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class SheetController : Controller
    {
        private SheetSevice _sheetSevice;
        private ClaimService _claim;
        public SheetController(SheetSevice sheetSevice,
            ClaimService claim)
        {
            _sheetSevice = sheetSevice;
            _claim = claim;
        }

        /// <summary>
        /// sheet 列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("sheetlist")]
        [HttpPost]
        public ApiResponse SheetList([FromBody] SheetRequest request)
        {
            var sheetList = _sheetSevice.SheetList(request.AllotID, request.Source);
            return new ApiResponse(ResponseType.OK, sheetList);
        }

        /// <summary>
        /// sheet 数据详情
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("sheetexport")]
        [HttpPost]
        public ApiResponse SheetExport([FromBody] SheetExportRequest request)
        {
            var exportData = _sheetSevice.SheetExport(request.SheetID);
            return new ApiResponse(ResponseType.OK, exportData);
        }

    }
}
