﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.DtoModels.Request;
using Performance.Services;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class SmsController : Controller
    {
        private SmsService _smsService;
        public SmsController(SmsService smsService)
        {
            this._smsService = smsService;
        }

        /// <summary>
        /// 发送验证码
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("code")]
        [HttpPost]
        [AllowAnonymous]
        public ApiResponse Code([FromBody] SmsCodeRequest request)
        {
            if (!_smsService.SendCode(request.Type, request.Mobile))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }

        /// <summary>
        /// 验证码验证
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("check")]
        [HttpPost]
        [AllowAnonymous]
        public ApiResponse Check([CustomizeValidator(RuleSet = "SmsCheck")][FromBody] SmsCodeRequest request)
        {
            if (!_smsService.Check(request.Mobile, request.Code))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
    }
}
