﻿using System;

namespace Performance.DtoModels
{
    public class PerAgainData
    {
        /// <summary>
        /// 行号
        /// </summary>
        public Nullable<int> RowNumber { get; set; }

        /// <summary>
        /// 列头类型名称
        /// </summary>
        public string TypeName { get; set; }

        /// <summary>
        /// 单元格value
        /// </summary>
        public Nullable<decimal> CellValue { get; set; }

        /// <summary>
        /// 1 汇总  2原始数据
        /// </summary>
        public Nullable<int> IsTotal { get; set; }

        /// <summary>
        /// 是否带入系数计算 1 带入 2 不带入
        /// </summary>
        public Nullable<int> IsFactor { get; set; }

        /// <summary>
        /// 系数值
        /// </summary>
        public Nullable<decimal> FactorValue { get; set; }

        /// <summary>
        /// 单元格注释
        /// </summary>
        public string Annotation { get; set; }

        /// <summary>
        /// 单元格备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string SignID { get; set; }

        public PerAgainData() { }

        public PerAgainData(int rowNumber, string typeName, decimal? cellValue, int isTotal, int isFactor,
            decimal? factorValue, string annotation, string remark, string signID)
        {
            this.RowNumber = rowNumber;
            this.TypeName = typeName;
            this.CellValue = cellValue;
            this.IsTotal = isTotal;
            this.IsFactor = isFactor;
            this.FactorValue = factorValue;
            this.Annotation = annotation;
            this.Remark = remark;
            this.SignID = signID;
        }
    }
}
