﻿using System;

namespace Performance.DtoModels
{
    public class PerAgainEmployee
    {
        /// <summary>
        /// 姓名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 职务
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 职称系数
        /// </summary>
        public Nullable<decimal> JobFactor { get; set; }

        /// <summary>
        /// 出勤
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }

        /// <summary>
        /// 年资
        /// </summary>
        public Nullable<decimal> YearFactor { get; set; }

        /// <summary>
        /// 重点奖励
        /// </summary>
        public Nullable<decimal> Award { get; set; }

        /// <summary>
        /// 管理津贴
        /// </summary>
        public Nullable<decimal> Allowance { get; set; }

        /// <summary>
        /// 单独核算人员绩效
        /// </summary>
        public Nullable<decimal> AlonePerfor { get; set; }

        /// <summary>
        /// 夜班费
        /// </summary>
        public Nullable<decimal> NightShift { get; set; }

        /// <summary>
        /// 职称出勤系数(需计算)
        /// </summary>
        public Nullable<decimal> JobAttendanceFactor { get; set; }

        /// <summary>
        /// 年资出勤系数(需计算)
        /// </summary>
        public Nullable<decimal> YearAttendanceFactor { get; set; }

        /// <summary>
        /// 职称出勤绩效(需计算)
        /// </summary>
        public Nullable<decimal> JobAttendancePerfor { get; set; }

        /// <summary>
        /// 应发绩效(需计算)
        /// </summary>
        public Nullable<decimal> GiveFee { get; set; }

        /// <summary>
        /// 实发绩效(需计算)
        /// </summary>
        public Nullable<decimal> RealGiveFee { get; set; }
        public int RowNumber { get; set; }
    }
}
