﻿using System.Collections.Generic;

namespace Performance.DtoModels.Request
{
    public class AddAssessSchemeItemsRequest
    {
        public int AllotId { get; set; }
        /// <summary>
        /// 方案ID
        /// </summary>
        public int SchemeId { get; set; }
        /// <summary>
        /// 一级指标名称
        /// </summary>
        public string ItemName1 { get; set; }
        /// <summary>
        /// 二级指标名称
        /// </summary>
        public string ItemName2 { get; set; }
        /// <summary>
        /// 考核分值
        /// </summary>
        public decimal AssessScore { get; set; }
        /// <summary>
        /// 考核标准
        /// </summary>
        public string AssessNorm { get; set; }
        /// <summary>
        /// <summary>
        /// 责任部门核算组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 责任部门核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
    }
    public class UpdateAssessSchemeItemsRequest : AddAssessSchemeItemsRequest
    {
        public int SchemeItemsId { get; set; }
    }
    public class BatchAssessSchemeItemsRequest
    {
        public int[] SchemeItemsId { get; set; }
    }
    public class QuerySchemeItemsTargetList
    {
        public int AllotId { get; set; }
        public int AssessId { get; set; }
        public int SchemeId { get; set; }
        public Assess.SchemeItemsTarget SchemeItemsTarget { get; set; }
        public string UnitType { get; set; }
        public string AccountingUnit { get; set; }
        public int Page { get; set; } = 1;
        public int PageSize { get; set; } = 20;
    }

    public class QuerySchemeItemsList
    {
        public int AllotId { get; set; }
        public int SchemeId { get; set; }
        /// <summary>
        /// 核算组别
        /// </summary>
        public string? UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string? AccountingUnit { get; set; }
        /// <summary>
        /// 二级指标名称
        /// </summary>
        public string? ItemName2 { get; set; }
        public int Page { get; set; } = 1;
        public int PageSize { get; set; } = 20;
    }
    public class TargetAssessSchemeItemsRequest
    {
        public List<AssessSchemeTargetResponse> SchemeTargetResponse { get; set; }

        public int SchemeId { get; set; }
    }
    public class TargetSchemeItemsTargetEdit
    {
        public int AllotId { get; set; }
        public int TargetId { get; set; }
        public string UnitType { get; set; }
        public string AccountingUnit { get; set; }
    }
    public class TargetSchemeItemsTargetDelete
    {
        public int[] TargetId { get; set; }
    }

}
