﻿using FluentValidation;

namespace Performance.DtoModels
{
    public class PasswordRequest
    {
        /// <summary>
        /// 原始密码
        /// </summary>
        public string OldPwd { get; set; }
        /// <summary>
        /// 新设密码
        /// </summary>
        public string NewPwd { get; set; }

        public class PasswordRequestValidator : AbstractValidator<PasswordRequest>
        {
            public PasswordRequestValidator()
            {
                RuleFor(x => x.OldPwd).NotNull().NotEmpty();

                RuleFor(x => x.NewPwd).NotNull().NotEmpty();
            }
        }
    }
}
