﻿using System;
using System.Collections.Generic;

namespace Performance.DtoModels.Response
{
    public class AttendanceAuditDetail
    {

        /// <summary>
        /// 考勤结果id(确认or驳回调用)
        /// </summary>
        public int AttendanceIsueId { get; set; }
        /// <summary>
        /// 绩效Id
        /// </summary>
        public int AllotId { get; set; }
        /// <summary>
        /// 核算单元编码
        /// </summary>
        public string Code { get; set; }
        /// <summary>
        /// 人员类别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 工号
        /// </summary>
        public string PersonnelNumber { get; set; }
        /// <summary>
        /// 姓名
        /// </summary>
        public string PersonnelName { get; set; }
        /// <summary>
        /// 人员系数
        /// </summary>
        public decimal PermanentStaff { get; set; }
        /// <summary>
        /// 在科开始时间
        /// </summary>
        public DateTime? BeginDate { get; set; }
        /// <summary>
        /// 在科结束时间
        /// </summary>
        public DateTime? EndDate { get; set; }
        /// <summary>
        /// 全勤天数
        /// </summary>
        public int WorkFullDays { get; set; }
        /// <summary>
        /// 出勤天数
        /// </summary>
        public int AttendanceDays { get; set; }
        /// <summary>
        /// 核减天数
        /// </summary>
        public int DeductionDays { get; set; }
        /// <summary>
        /// 不核减天数
        /// </summary>
        public int NoDeductionDays { get; set; }
        /// <summary>
        /// 状态 未确认 = 1,确认 = 2,驳回 = 3
        /// </summary>
        public int State { get; set; }
        /// <summary>
        /// 确定用户
        /// </summary>
        public string ConfirmUser { get; set; }
        /// <summary>
        /// 确定时间
        /// </summary>
        public DateTime? ConfirmTime { get; set; }

        public List<AttendanceAuditDetails> Detial { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remarks { get; set; }
    }
    public class AttendanceAuditDetails
    {
        /// <summary>
        /// 请假天数
        /// </summary>
        public object Value { get; set; }
        /// <summary>
        /// 考勤类型
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
    }
}
