﻿using System;

namespace Performance.DtoModels.Response
{
    public class AttendanceDeptState : AttendanceDeptAuditList
    {
        /// <summary>
        /// 标题名
        /// </summary>
        public string Title { get; set; }
    }
    public class AttendanceDeptAuditList
    {
        /// <summary>
        /// 编码
        /// </summary>
        public string Code { get; set; }
        /// <summary>
        /// 核算组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 总下发数
        /// </summary>
        public int Count { get; set; }
        /// <summary>
        /// 确认数
        /// </summary>
        public int ConfirmCount { get; set; }
        /// <summary>
        /// 通过数
        /// </summary>
        public int FinishCount { get; set; }
        /// <summary>
        /// 驳回数
        /// </summary>
        public int RejectCount { get; set; }

        /// <summary> 
        /// 状态(未提交 = 1,提交 = 2,通过 = 3,驳回 = 4) 
        /// </summary>
        public int State { get; set; }
        /// <summary>
        /// 提交人
        /// </summary>
        public string SubmitUser { get; set; }
        /// <summary>
        /// 提交时间
        /// </summary>
        public DateTime? SubmitTime { get; set; }
        /// <summary>
        /// 审核人
        /// </summary>
        public string AuditUser { get; set; }
        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditTime { get; set; }
        /// <summary>
        /// 状态描述
        /// </summary>
        public string Remarks { get; set; }
    }
}
