﻿using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class OwnerPerformanceDto : view_allot_result
    {
        public IEnumerable<OwnerPerformanceDto> Detail { get; set; }
        /// <summary>
        /// 预留比例
        /// </summary>
        public decimal? ReservedRatio { get; set; }
        /// <summary>
        /// 实发绩效
        /// </summary>
        public decimal RealGiveFee { get; set; }
        /// <summary>
        /// 发放时间
        /// </summary>
        public string IssueDate { get; set; }
    }


    public class OwnerMobilePerformanceDto
    {
        /// <summary>
        /// 绩效发放总额
        /// </summary>
        public decimal Total { get; set; }
        /// <summary>
        /// 绩效明细
        /// </summary>
        public List<OwnerMobileItemDto> Items { get; set; }
    }
    public class OwnerMobileItemDto
    {
        /// <summary>
        /// 类型名称
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// 金额
        /// </summary>
        public decimal Amount { get; set; }
        /// <summary>
        /// 明细项
        /// </summary>
        public List<OwnerMobileItemDetailDto> Details { get; set; }
    }
    public class OwnerMobileItemDetailDto
    {
        /// <summary>
        /// 类型名称
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// 金额
        /// </summary>
        public decimal Amount { get; set; }
        /// <summary>
        /// 发放时间，空则不显示
        /// </summary>
        public string Date { get; set; }
    }
}
