﻿using System;
using Performance.EntityModels;
using Performance.EntityModels.Other;

namespace Performance.DtoModels
{
    /// <summary>
    /// 考核下发结果统计
    /// </summary>
    public class PerAssessmentStatisticsResponse
    {

        public PerAssessmentStatisticsResponse() { }

        public PerAssessmentStatisticsResponse(view_assess_issue item)
        {
            Id = 0;
            AllotId = item.AllotId;
            AssessId = item.AssessId;
            AssessCode = item.AssessCode;
            AssessName = item.AssessName;
            SchemeId = item.SchemeId;
            SchemeCode = item.SchemeCode;
            SchemeName = item.SchemeName;
            ItemId = item.ItemId;
            ItemCode = item.ItemCode;
            ItemName1 = item.ItemName1;
            ItemName2 = item.ItemName2;
            AssessScore = item.AssessScore;
            AssessNorm = item.AssessNorm;
            UnitCode = item.UnitCode;
            UnitType = item.UnitType;
            AccountingUnit = item.AccountingUnit;
            TargetUnitCode = item.TargetUnitCode;
            TargetUnitType = item.TargetUnitType;
            TargetAccountingUnit = item.TargetAccountingUnit;
            OperationType = (int)Attendance.OperationType.新增;
            Describe = "添加数据";
        }

        public PerAssessmentStatisticsResponse(per_assess_issue_scheme item)
        {
            Id = item.Id;
            AllotId = item.AllotId;
            AssessId = item.AssessId;
            AssessCode = item.AssessCode;
            AssessName = item.AssessName;
            SchemeId = item.SchemeId ?? 0;
            SchemeCode = item.SchemeCode;
            SchemeName = item.SchemeName;
            ItemId = item.ItemId ?? 0;
            ItemCode = item.ItemCode;
            ItemName1 = item.ItemName1;
            ItemName2 = item.ItemName2;
            AssessScore = item.AssessScore;
            AssessNorm = item.AssessNorm;
            UnitCode = item.UnitCode;
            UnitType = item.UnitType;
            AccountingUnit = item.AccountingUnit;
            TargetUnitCode = item.TargetUnitCode;
            TargetUnitType = item.TargetUnitType;
            TargetAccountingUnit = item.TargetAccountingUnit;
            OperationType = (int)Attendance.OperationType.删除;
            Describe = "删除数据";

        }

        /// <summary>
        /// 
        /// </summary>
        public int? Id { get; set; }
        /// <summary>
        /// 绩效ID
        /// </summary>
        public Nullable<int> AllotId { get; set; }
        /// <summary>
        /// 考核类型ID
        /// </summary>
        public int AssessId { get; set; }
        /// <summary>
        /// 考核类型编码
        /// </summary>
        public string AssessCode { get; set; }
        /// <summary>
        /// 考核类型名称
        /// </summary>
        public string AssessName { get; set; }
        /// <summary>
        /// 考核方案ID
        /// </summary>
        public int SchemeId { get; set; }
        /// <summary>
        /// 考核方案编码
        /// </summary>
        public string SchemeCode { get; set; }
        /// <summary>
        /// 考核方案名称
        /// </summary>
        public string SchemeName { get; set; }
        /// <summary>
        /// 考核指标Id
        /// </summary>
        public int ItemId { get; set; }
        /// <summary>
        /// 指标编码
        /// </summary>
        public string ItemCode { get; set; }
        /// <summary>
        /// 一级指标名称
        /// </summary>
        public string ItemName1 { get; set; }
        /// <summary>
        /// 二级指标名称
        /// </summary>
        public string ItemName2 { get; set; }
        /// <summary>
        /// 考核分值
        /// </summary>
        public decimal AssessScore { get; set; }
        /// <summary>
        /// 考核标准
        /// </summary>
        public string AssessNorm { get; set; }
        /// <summary>
        /// 责任部门核算单元编码
        /// </summary>
        public string UnitCode { get; set; }
        /// <summary>
        /// 责任部门核算组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 责任部门核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 考核目标核算单元编码
        /// </summary>
        public string TargetUnitCode { get; set; }
        /// <summary>
        /// 考核目标核算组别
        /// </summary>
        public string TargetUnitType { get; set; }
        /// <summary>
        /// 考核目标核算单元
        /// </summary>
        public string TargetAccountingUnit { get; set; }
        /// <summary>
        /// 操作类型 新增 = 1, 修改 = 2, 删除 = 3,
        /// </summary>
        public int OperationType { get; set; }
        /// <summary>
        /// 操作描述 
        /// </summary>
        public string Describe { get; set; }
    }
}
