﻿using System;
using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class SecondResponse
    {
        public List<HeadItem> HeadItems { get; set; }
        public List<BodyItem> BodyItems { get; set; }
    }

    public class HeadItem : ICloneable
    {
        public string FiledId { get; set; }
        public string FiledName { get; set; }
        public decimal Sort { get; set; }
        public int Type { get; set; }
        public decimal FactorValue { get; set; }
        public int SourceType { get; set; }

        /// <summary> 1 带出历史数据 2不带出 </summary>
        public Nullable<int> IsBring { get; set; }

        /// <summary> 1 value相加值为1 </summary>
        public Nullable<int> SpecialAttr { get; set; }

        public Nullable<int> WorkType { get; set; }

        public object Clone()
        {
            return MemberwiseClone();
        }
    }

    public class BodyItem : HeadItem
    {
        public int RowNumber { get; set; }
        public string Value { get; set; }

        public BodyItem()
        {
        }

        public BodyItem(HeadItem headItem)
        {
            FiledId = headItem.FiledId;
            FiledName = headItem.FiledName;
            Sort = headItem.Sort;
            Type = headItem.Type;
            FactorValue = headItem.FactorValue;
            SourceType = headItem.SourceType;
            IsBring = headItem.IsBring;
            SpecialAttr = headItem.SpecialAttr;
        }
    }
}
