﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Performance.EntityModels.Entity;

namespace Performance.EntityModels.Context.Configurations
{
    /// <summary>
    /// 定义数据模型(per_attendance_type)
    /// </summary>
    public partial class PerAttendanceTypeConfiguration : IEntityTypeConfiguration<per_attendance_type>
    {
        public void Configure(EntityTypeBuilder<per_attendance_type> entity)
        {
            entity.HasKey(x => new { x.Id, x.AllotId })
                .HasName("PRIMARY")
                .HasAnnotation("MySql:IndexPrrfixLength", new[] { 0, 0 });
            entity.ToTable("per_attendance_type");
        }
    }
}
