//-----------------------------------------------------------------------
// <copyright file=" per_assess_scheme_items.cs">
// * FileName: 考核方案指标项.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 考核方案指标项
    /// </summary>
    [Table("per_assess_scheme_items")]
    public class per_assess_scheme_items
    {
        /// <summary>
        /// 指标项Id
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 绩效ID
        /// </summary>
        public Nullable<int> AllotId { get; set; }
        /// <summary>
        /// 考核类型ID
        /// </summary>
        public int AssessId { get; set; }
        /// <summary>
        /// 考核方案Id
        /// </summary>
        public int SchemeId { get; set; }
        /// <summary>
        /// 指标编码
        /// </summary>
        public string ItemCode { get; set; }
        /// <summary>
        /// 一级指标名称
        /// </summary>
        public string ItemName1 { get; set; }
        /// <summary>
        /// 二级指标名称
        /// </summary>
        public string ItemName2 { get; set; }
        /// <summary>
        /// 考核分值
        /// </summary>
        public decimal AssessScore { get; set; }
        /// <summary>
        /// 考核标准
        /// </summary>
        public string AssessNorm { get; set; }
        /// <summary>
        /// 责任部门核算单元编码
        /// </summary>
        public string UnitCode { get; set; }
        /// <summary>
        /// 责任部门核算组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 责任部门核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? CreateTime { get; set; }
        /// <summary>
        /// 最后修改人
        /// </summary>
        public int UpdateBy { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
    }
}
